---
title: Functional
localeTitle: функциональная
---
```javascript
var fun = function(a, b) { 
  var funInstance = {}; 
  funInstance.a = a; 
  funInstance.b = b; 
  funInstance.method1 = function() { 
    // method code here 
  } 
  funInstance.method2 = function() { 
    // method code here 
  } 
  funInstance.method3 = function() { 
    // method code here 
  } 
  return funInstance; 
 } 
 var myFun = fun(1, 2); 
 myFun.method1(); 
```

## Как я узнаю его?

Функциональное создание объекта создает экземпляр класса с функцией, как и другие параметры. Разница в том, что все связанные методы также определены в функции конструктора.

## Зачем мне это использовать?

Поскольку для каждого экземпляра объекта создается новый набор методов, и он может принимать взвешенный объем памяти, функциональная конкретизация хороша, если вы знаете, что не собираетесь работать со множеством экземпляров. Это также хорошо для того, чтобы ваш код был легко понят новыми и опытными JavaScript-кодами, так как создание полностью самодостаточно, и легко видеть связи между методами и экземплярами объектов.

## Каковы недостатки?

Нижняя сторона с Functional Instantiation заключается в том, что если вы внесете какие-либо изменения в свой код (например, добавив больше методов), любые экземпляры объекта, которые были созданы до этих изменений, не будут обновляться. В итоге вы можете использовать два экземпляра, содержащих информацию о различных методах.

* * *

## название: Функциональный

```javascript
var fun = function(a, b) { 
  var funInstance = {}; 
  funInstance.a = a; 
  funInstance.b = b; 
  extend(funInstance, funMethods); 
  return funInstance; 
 } 
 var extend = function(to, from) { 
  for (var key in from) { 
    to[key] = from[key]; 
  } 
 } 
 var funMethods = {}; 
 funMethods.method1 = function() { 
    // method code here 
 } 
 funMethods.method2 = function() { 
    // method code here 
 } 
 funMethods.method3 = function() { 
    // method code here 
 } 
 var myFun = fun(1, 2); 
 myFun.method1(); 
```

## Как я узнаю его?

Основное различие между Functional и Functional-Shared заключается в том, что в Functional-Shared мы совместно используем наши методы. Вместо того, чтобы объявлять методы в нашей функции Instantiation, у нас есть отдельный объект, содержащий все наши методы. Чтобы использовать методы, мы расширяем их в каждый экземпляр объекта, который создается.

## Зачем мне это использовать?

Functional-Shared позволяет нам использовать ссылки на методы, а не декларировать и хранить наши методы для каждого экземпляра нашего объекта, сохраняя пространство.

## Каковы недостатки?

Недостатком является то, что, поскольку методы ссылаются через указатели на объект методов, если бы мы каким-либо образом обновляли объект методов, экземпляры объекта, которые были созданы до изменений, не обновлялись. Вы могли бы получить два экземпляра объекта, ссылающихся на две разные версии методов.

* * *

## название: прототип

```javascript
var fun = function(a, b) { 
  var funInstance = Object.create(funMethods); 
  funInstance.a = a; 
  funInstance.b = b; 
  return funInstance; 
 } 
 var funMethods = {}; 
 funMethods.method1 = function() { 
    // method code here 
 } 
 funMethods.method2 = function() { 
    // method code here 
 } 
 funMethods.method3 = function() { 
    // method code here 
 } 
 var myFun = fun(1, 2); 
 myFun.method1(); 
```

## Как я узнаю его?

Прототипал похож на функционально-разделенный на то, что они оба используют отдельный объект методов для хранения всех методов, которые будут совместно использоваться экземплярами объекта, который мы создаем. Разница в том, что мы можем использовать цепочку прототипов. Мы можем создать объект, используя Object.create (prototype), чтобы прикрепить методы к нашему экземпляру объекта. Прототипом считается объект, который держит наши общие методы.

## Зачем мне это использовать?

Если вы внесете изменения в свой прототип после создания экземпляра объекта, этот экземпляр будет обновлен. У вас не будет двух экземпляров с тем же прототипом, который имеет разные методы.

## Каковы недостатки?

Недостатки использования этого метода заключаются в том, что он требует дополнительных шагов и дополнительного кода. Мы должны не только создавать и возвращать наш объект, как раньше, но мы также должны его украшать.

* * *

## название: псевдоклассическое

```javascript
var Fun = function(a, b) { 
  // this = Object.create(Fun.prototype); 
  this.a = a; 
  this.b = b; 
  // return this; 
 } 
 Fun.prototype.method1 = function() { 
    // method code here 
 } 
 Fun.prototype.method2 = function() { 
    // method code here 
 } 
 Fun.prototype.method3 = function() { 
    // method code here 
 } 
 var myFun = new Fun(1, 2); 
 myFun.method1(); 
```

## Как я узнаю его?

Псевдоклассическое создание на данный момент содержит наименьшее количество кода. Вместо того, чтобы создавать новый объект и возвращать его, новое ключевое слово делает это для нас. Под капотом, когда вы используете новое ключевое слово для создания объекта, вы создаете новый объект, используя этот объект = Object.create (Object.prototype), где это относится к прототипу, названному после нового ключевого слова. Когда мы определяем наши методы, мы используем ключевое слово prototype.

## Зачем мне это использовать?

Говорят, что псевдоклассический является самым быстрым шаблоном создания, который полезен, если вы создаете десятки тысяч экземпляров. Он также наиболее оптимизирован, так как он использует функциональность Javascript.

## Каковы недостатки?

Недостатком псевдоклассического инстанцирования является то, что он требует немного больше знаний о том, что делает JavaScript под капотом, особенно с этим ключевым словом. Это делает этот тип экземпляра объекта более сложным для понимания, особенно если кто-то читает ваш код