---
title: Regular Expressions Reference
localeTitle: Справочник по регулярным выражениям
---
## Справочник по регулярным выражениям

В JavaScript регулярные выражения являются сокращением, используемым для соответствия требуемой части строки. Это полезно при попытке манипулировать или проверять строки, используемые в вашем коде.

### Синтаксис

Регулярные выражения состоят из двух частей - `pattern` и `flags` (необязательно). Шаблон записывается между двумя косяками вперед, за которым следуют необязательные флаги: `var exp = /pattern/flags` .

#### Узоры

Использование буквенно-цифровых символов (AZ, az, 0-9) делает простое совпадение. Однако реальная сила регулярных выражений имеет классы символов.

Скажем, например, вы хотите, чтобы во всех местах была строка с числом от 0 до 9. Вместо явного вызова `/[0-9]/` , вы можете использовать специальный класс символов `/\d/` . Обратная косая черта выходит из символа `d` (поэтому не совпадает с буквой `d` ), но вместо этого использует специальные возможности сопоставления `\d` .

Этот же принцип применяется к нечисловым символам, пробелу и другим широким группам соответствия. Регулярные выражения могут стать еще более сложными с использованием определенных модификаторов, таких как символ `+` .

Этот квантификатор позволяет вам сопоставлять предыдущий символ в вашем шаблоне один или несколько раз. `/s+/` будет соответствовать `s` в `desert` , и оба `s` «ы в `dessert` !

Есть еще много модификаторов, которые позволяют вашему шаблону соответствовать всем, что вам может понадобиться. См. Раздел «Дополнительная информация» ниже, чтобы просмотреть все возможные варианты символов для использования в регулярных выражениях.

#### Флаги

Существует 5 флагов, которые вы можете использовать для применения определенных правил ко всему регулярному выражению, которое вы пишете. Они есть:

`g` - глобальный матч; это позволяет вам сопоставлять все экземпляры вашего выражения, а не останавливаться после первого появления.

`i` - совпадение в случае игнорирования (само собой разумеющееся)

`m` - многострочный матч; это применит ваш шаблон к каждой строке как новый; если вы ищете строку, начинающуюся с определенного шаблона, это делается для всех строк, а не только для первого

`u` - соответствие Юникод; это означает, что вы читаете ваш шаблон как Unicode, а не обычный текст

`y` - липкий матч; это соответствует вашему шаблону, только начиная с индекса, найденного в свойстве `RegExp.lastIndex`

### Создание регулярного выражения

Регулярное выражение - это тип объекта. Он может быть построен с конструктором RegExp или записывается как буквальное значение, шаблон в символах прямой косой черты (/).
```
var re1 = new RegExp (" abc ") ; 
 var re2 = / abc /; 
```

Оба этих объекта регулярного выражения представляют один и тот же шаблон: символ, за которым следует ab, а затем c.

### Объект RegExp

`RegExp` - это конструктор, который создает объект из создаваемого шаблона регулярных выражений. В дополнение к литеральной нотации, описанной выше, вы также можете использовать формат конструктора для создания регулярного выражения: `new RegExp(pattern[, flags])`

### Тестирование матчей
```
console . log (/ abc /. test (" abcde ") ); 
 // → true 
 console . log (/ abc /. test (" abxde ") ); 
 // → false 
```

### Соответствие набора символов
```
console . log (/[0123456789]/. test (" in 1992") ); 
 // → true 
 console . log (/[0 -9]/. test (" in 1992") ); 
 // → true 
```

### Шаблоны выбора
```
var animalCount = /\ b \ d + ( pig | cow | chicken )s ?\ b /; 
 console . log ( animalCount . test ("15 pigs ") ); 
 // → true 
 console . log ( animalCount . test ("15 pigchickens ") ); 
 // → false 
```

#### методы

Скорее всего, вы будете использовать регулярные выражения в методах `String` , таких как `String.replace()` , но есть несколько методов, относящихся к объекту `RegExp` .

Например, `RegExp.test()` вернет логическое значение для того, существует ли соответствие между шаблоном регулярного выражения и соответствующей строкой. `RegExp.toString()` превратит объект выражения в строку, что может быть удобно при выполнении тестов кода.

Первый аргумент также может быть регулярным выражением, и в этом случае первое совпадение регулярного выражения заменяется. Когда в регулярное выражение добавляется опция ag (для global), все совпадения в строке будут заменены не только первыми.
```
console . log (" Borobudur ". replace (/[ ou ]/ , "a ") ); 
 // → Barobudur 
 console . log (" Borobudur ". replace (/[ ou ]/g , "a ") ); 
 // → Barabadar 
```

### Дополнительная информация:

*   [Здесь вы можете прочитать](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp) обо всех символах соответствия шаблонов, свойствах объектов, некоторых примерах и т. Д.
    
*   [Вот отличный сайт,](https://regex101.com/) который позволяет вам проверять шаблоны регулярных выражений в режиме реального времени, сохранять ваши избранные и исследовать шаблоны, сделанные другими.