---
title: Rest Parameters
localeTitle: Параметры останова
---
## Параметры останова

В ES6 синтаксис остального параметра `...` позволяет собирать неопределенное количество аргументов в массив.

Несмотря на то, что они выглядят одинаково, это делает противоположность оператора спреда, который берет каждый элемент из итерации и распространяет их на свои индивидуальные значения.

### Синтаксис

```js
function myFunc(...args) { 
  console.log(args); 
 } 
 
 myFunc( 1, 2, 3, 4, 5);       // [1,2,3,4,5] 
```

Вы можете префикс последнего параметра функции `...` когда вы хотите что-то сделать с исходными параметрами, а затем обрабатывать все остальные параметры по-разному.

```js
function convertCurrency(rate, fee, ...amounts) { 
  return amounts.map(amount => (amount * rate) + fee); 
 } 
 
 convertCurrency(0.89, 2.5, 100, 250, 75, 150, 300); // [ 91.5, 225, 69.25, 136, 269.5 ] 
```

The `...` позволяет собирать остальные аргументы, если они есть, в массив.

### Разница между параметрами отдыха и объектом аргументов

`arguments` - это массивный объект, доступный внутри функций, содержащий аргументы, переданные этим функциям. Он называется «подобный массиву», потому что он не имеет всех встроенных методов массива, таких как `.forEach()` и `.map()` .

Остальные параметры - это массив, в который включены все методы массива.