---
title: Semicolons
localeTitle: Точка с запятой
---
Точки с запятой не требуются в Javascript. Это связано с тем, что Javascript имеет функцию «Automatic Semicolon Insertion» или ASI для краткости. ASI помещает точки с запятой в ваш Javascript для вас. Он всегда активен по умолчанию, и он является частью языка и не может быть отключен.

ASI имеет набор правил, которые он использует, чтобы определить, где он должен вставить точки с запятой. Если уже имеется точка с запятой, это ничего не изменит. См. [Этот ответ StackOverflow](http://stackoverflow.com/a/2846298/3467946) для получения дополнительной информации о том, как работает ASI.

Существует только один случай, когда ASI завершается с ошибкой: когда строка начинается с открывающей скобки `(` Чтобы избежать этой ошибки, когда линия начинается с открывающей скобки, вы можете положить точку с запятой в начале строки с открытой скобой :

```js
;(function() { 
  console.log('Hi!') 
 }) 
```

Обратите внимание, что это необходимо только в том случае, если вы не используете точки с запятой.

Согласованный стиль кодирования делает код более читаемым. Решите, будете ли вы или не будете использовать точки с запятой, и делайте это везде.

## Ошибки, которые могут возникнуть

Когда Javascript был впервые создан, он призван помочь начинающим программистам. Никто не хочет искать проклятую точку с запятой в своем коде, когда они только начинают программировать. Таким образом, выбор точек с запятой был реализован, как указано выше, они технически существуют.

Например: `javasctipt function foo(x) { return function(y) { return x + y; } } let z = foo(10); z(10)// TypeError z is not a function // Because of Automatic Semicolon Insertion, our inner function does not exist.` 

Javasctipt будет применять точки с запятой там, где они необходимы.

### Другие источники

[Открытое письмо лидерам JavaScript в отношении точек с запятой](http://blog.izs.me/post/2353458699/an-open-letter-to-javascript-leaders-regarding)
