---
title: Array.prototype.push
localeTitle: Array.prototype.push
---
Метод `push()` используется для добавления одного или нескольких новых элементов в конец массива. Он также возвращает новую длину массива.

### Синтаксис

```javascript
arr.push([element1[, ...[, elementN]]]) 
```

### параметры

*   **elementN** Элементы для добавления в конец массива.

### Возвращаемое значение

Новая длина массива, на который был вызван метод.

## Описание

Метод `push()` будет _толкать_ элементы до конца массива. Он может принимать ноль или более аргументов. Если аргументы не предоставлены, он просто вернет текущую длину массива. Если предоставлен один или несколько аргументов, он добавит эти аргументы в массив в том порядке, в котором они написаны.

Этот метод также возвращает новую длину массива после нажатия на элемент (элементы).

## Пример:

```javascript
var myStarkFamily = ['John', 'Robb', 'Sansa', 'Bran']; 
```

Предположим, у вас есть массив детей Дома Старка из «Игры престолов». Однако один из членов, **Арья** , отсутствует. Зная код выше, вы можете добавить ее, присвоив `'Arya'` массиву в индексе после последнего индекса, например:

```javascript
myStarkFamily[4] = 'Arya'; 
```

Проблема с этим решением заключается в том, что он не может обрабатывать общие случаи. Если вы заранее не знали, что такое длина массива, вы не можете добавлять новые элементы таким образом. Это то, что для `push()` . Нам не нужно знать, как долго массив. Мы просто добавляем наш элемент до конца массива.

```javascript
myStarkFamily.push('Arya'); 
 console.log(myStarkFamily);  // ['John', 'Robb', 'Sansa', 'Bran', 'Arya'] 
 
 var newLength = myStarkFamily.push('Rickon');  // oops! forgot Rickon 
 console.log(newLength);  // 6 
 console.log(myStarkFamily);  // ['John', 'Robb', 'Sansa', 'Bran', 'Arya', 'Rickon'] 
```

#### Дополнительная информация:

[MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/push)