---
title: Array.prototype.reduce
localeTitle: Array.prototype.reduce
---
## Array.prototype.reduce

Метод `reduce()` уменьшает массив значений до одного значения.

Единственное возвращаемое значение может быть любого типа.

### Пример 1

Преобразуйте массив целых чисел в сумму всех целых чисел в массиве.

```js
    var numbers = [1,2,3]; 
    var sum = numbers.reduce(function(total, current){ 
        return total + current; 
    }); 
    console.log(sum); 
```

Это выведет `6` на консоль.

### Описание

Метод `reduce()` был назван швейцарским армейским ножом или мультиинструментом методов преобразования массива. Другие, такие как `map()` и `filter()` , обеспечивают более конкретные преобразования, тогда как `reduce()` может использоваться для преобразования массивов в любой желаемый результат.

### Синтаксис

```js
    arr.reduce(callback[, initialValue]) 
```

*   Аргумент `callback` - это функция, которая будет вызываться один раз для каждого элемента массива. Эта функция принимает четыре аргумента, но часто используются только первые две.
    *   _accumulator_ - возвращаемое значение предыдущей итерации
    *   _currentValue_ - текущий элемент массива
    *   _index_ - индекс текущего элемента
    *   _array_ - исходный массив, на который был вызван сокращение
*   Аргумент `initialValue` является обязательным. Если это предусмотрено, оно будет использоваться в качестве начального значения аккумулятора при первом вызове функции обратного вызова (см. Пример 2 ниже).

### Пример 2.

Преобразуйте массив строк в один объект, который показывает, сколько раз каждая строка появляется в массиве. Обратите внимание, что этот вызов уменьшает пропускает пустой объект `{}` как параметр `initialValue` . Это будет использоваться в качестве начального значения аккумулятора (первого аргумента), переданного функции обратного вызова.

```js
var pets = ['dog', 'chicken', 'cat', 'dog', 'chicken', 'chicken', 'rabbit']; 
 
 var petCounts = pets.reduce(function(obj, pet){ 
    if (!obj[pet]) { 
        obj[pet] = 1; 
    } else { 
        obj[pet]++; 
    } 
    return obj; 
 }, {}); 
 
 console.log(petCounts); 
```

Вывод: `js { dog: 2, chicken: 3, cat: 1, rabbit: 1 }`

## Дополнительная информация:

*   [Как работает метод сокращения JavaScript, когда его использовать, и некоторые из интересных вещей, которые он может сделать](https://medium.freecodecamp.org/reduce-f47a7da511a9)
*   [Расширенное сокращение](https://www.youtube.com/watch?v=1DMolJ2FrNY)
*   [MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/Reduce)