---
title: JSON Syntax
localeTitle: Синтаксис JSON
---
## Синтаксис JSON

Синтаксис JSON является подмножеством синтаксиса JavaScript.

### Правила синтаксиса JSON

*   JSON Object - неупорядоченный набор пар имя / значение.
*   За именами объектов следует двоеточие (:).
*   Кулистые фигурные скобки {} используются для хранения объектов. Объект начинается с {(левая фигурная скобка) и заканчивается на} (правая фигурная скобка).
*   Данные объекта JSON представлены в виде набора пар имя / значение.
*   Каждая пара имен / значений разделяется запятой (,)
*   Квадратные фигурные скобки \[\] используются для хранения массивов.

### Данные JSON - имя и стоимость

Данные JSON записываются как пары имя / значение.

Пара имя / значение состоит из имени поля (в двойных кавычках), за которым следует двоеточие, за которым следует значение:
```
"handle":"moghya" 
```

*   Для имен JSON требуются двойные кавычки.

### JSON - оценивает объекты JavaScript

Формат JSON почти идентичен JavaScript-объектам.

В JSON ключи должны быть строками, написанными двойными кавычками:

*   JSON
```
"handle":"moghya" 
```

*   JavaScript
```
handle:"moghya" 
```

### Значения JSON

В JSON значения должны быть одного из следующих типов данных:

*   строка
*   число
*   объект (объект JSON)
*   массив
*   логическое
*   ноль

В значениях JavaScript могут быть все перечисленные выше, а также любое другое действительное выражение JavaScript, в том числе:

*   функция
*   свидание
*   не определено

### JSON использует синтаксис JavaScript

Поскольку синтаксис JSON получен из нотации объекта JavaScript, для работы с JSON в JavaScript требуется очень мало дополнительного программного обеспечения.

С помощью JavaScript вы можете создать объект и присвоить ему данные, например:
```
var person = { 
  "name":"Shubham", 
  "age":21, 
  "handle":"moghya", 
  "website":"http://moghya.me/" 
  }; 
```

Вы можете получить доступ к объекту JavaScript следующим образом:
```
//returns moghya 
 person.handle; 
```

Он также может быть доступен следующим образом:
```
//returns http://moghya.me/ 
 person["website"]; 
```

### Массивы в JSON
```
var team = { 
  "name":"novatoscript", 
  "members" : 
  [ 
    { 
      "name":"Shubham Sawant", 
      "age":21, 
      "handle":"moghya", 
      "website":"http://moghya.me", 
    }, 
    { 
      "name":"Saurabh Banore", 
      "age":21, 
      "handle":"banoresaurabh", 
      "website":"http://banoresaurabh.me/", 
    } 
  ] 
 } 
```

### пример

Очень большой пример JSON [здесь!](http://moghya.me/js/profile.json) ,