---
title: Math Max
localeTitle: Math Max
---
## Math Max

`Math.max()` - это функция, которая возвращает наибольшее значение из списка числовых значений, переданных в качестве параметров. Если в качестве параметра передается нечисловое значение, `Math.max()` вернет `NaN` .

Массив числовых значений может быть передан как один параметр в `Math.max()` используя либо `spread (...)` либо `apply` . Однако любой из этих методов может потерпеть неудачу, когда количество значений массива становится слишком высоким.

### Синтаксис

```js
Math.max(value1, value2, value3, ...); 
```

### параметры

Числа или ограниченный набор чисел.

### Возвращаемое значение

Наибольший из заданных числовых значений или `NaN` если какое-либо заданное значение не является числовым.

### Примеры

_Числа как параметры_

```js
Math.max(4, 13, 27, 0, -5); // returns 27 
```

_Неверный параметр_

```js
Math.max(4, 13, 27, 'eight', -5); // returns NaN 
```

_Массив в качестве параметра, использование спреда (...)_

```js
let numbers = [4, 13, 27, 0, -5]; 
 
 Math.max(...numbers); // returns 27 
```

_Массив как параметр, используя приложение_

```js
let numbers = [4, 13, 27, 0, -5]; 
 
 Math.max.apply(null, numbers); // returns 27 
```

#### Дополнительная информация:

[MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/max)