---
title: Strict Mode
localeTitle: Строгий режим
---
Строгий режим был введен в ECMAScript 5, который позволяет размещать программу или функцию в «строгом» рабочем контексте. Этот строгий контекст предотвращает принятие определенных действий и выдает больше исключений.

Строгий режим делает несколько изменений в обычной семантике JavaScript.

*   Во-первых, строгий режим устраняет некоторые ошибки в JavaScript без изменения ошибок.
*   Во-вторых, строгий режим исправляет ошибки, которые затрудняют выполнение JavaScript-движками: строгий режимный код иногда может запускаться быстрее, чем идентичный код, который не является строгим.
*   В-третьих, строгий режим запрещает некоторый синтаксис, который может быть определен в будущих версиях ECMAScript.

Строгий режимный код и нестрогий код режима могут сосуществовать в одном скрипте.

```javascript
// Non-strict code... 
 
 (function(){ 
    "use strict"; 
 
    // Define your library strictly... 
 })(); 
 
 // Non-strict code... 
```

## Вызов строгого режима

Строгий режим применяется ко _всем скриптам_ или к _отдельным функциям_ .

**Строгий режим для скриптов**

```javascript
// Whole-script strict mode syntax 
 
 "use strict"; 
 var v = "Hi!  I'm a strict mode script!"; 
```

**Строгий режим для функций**

```javascript
function strict(){ 
    // Function-level strict mode syntax 
 
    'use strict'; 
    function nested() { return "And so am I!"; } 
    return "Hi!  I'm a strict mode function!  " + nested(); 
 } 
 
 function notStrict() { return "I'm not strict."; } 
```

**В основном это помогает сделать меньше ошибок, обнаруживая вещи, которые могут привести к поломке, которые не обнаружены нормально (нестрогий режим).**

_Для получения дополнительной информации ознакомьтесь с этой [страницей MDN](https://developer.mozilla.org/en/docs/Web/JavaScript/Reference/Strict_mode) ._