---
title: Timing Events
localeTitle: Сроки проведения
---
## Сроки проведения

Программисты используют события синхронизации для задержки выполнения кода или повторения кода с заданным интервалом.

В библиотеке JavaScript, используемой для выполнения этих задач, есть две встроенные функции: `setTimeout()` и `setInterval()` .

Вы используете `setTimeout()` для задержки выполнения переданной функции на определенное количество времени. Есть два параметра, которые вы передаете `setTimeout()` : функция, которую вы хотите вызвать, и количество времени в миллисекундах. (В течение 1 секунды используется 1000 миллисекунд (мс). Пример: 5000 мс = 5 секунд.) `setTimeout()` будет выполняться один раз по истечении указанного времени.

Пример `setTimeout()` :

```javascript
var timeoutID; 
 
 function delayTimer() { 
  timeoutID = setTimeout(delayedFunction, 3000); 
 } 
 
 function delayedFunction() { 
  alert(“Three seconds have elapsed.”); 
 } 
```

Когда вызывается функция delayTimer, она запускает setTimeout. По прошествии 3 секунд он выполнит функцию delayedFunction, которая отправит предупреждение.

Используйте `setInterval()` чтобы указать функцию, которая будет повторяться с временной задержкой между execuions. Опять же, два параметра передаются `setInterval()` : функция, которую вы хотите вызвать, и количество времени в миллисекундах. `setInterval()` будет продолжать выполнение до тех пор, пока оно не будет очищено.

`setInterval()` :

```javascript
var intervalID; 
 
 function repeatEverySecond() { 
  intervalID = setInterval(sendMessage, 1000); 
 } 
 
 function sendMessage() { 
  console.log(“One second elapsed.”); 
 } 
```

Когда ваш код вызывает функцию repeatEverySecond, он запустит setInterval. setInterval будет запускать функцию sendMessage каждые 1000 миллисекунд.

Существуют также соответствующие нативные функции для остановки событий синхронизации: `clearTimeout()` и `clearInterval()` .

Возможно, вы заметили, что каждая функция таймера сохраняется в переменной. Когда запущена функция set, ей присваивается номер, который сохраняется в этой переменной. Это сгенерированное число уникально для каждого экземпляра таймеров. Это назначенное число также определяет, как таймеры идентифицируются как остановленные. По этой причине вы всегда должны устанавливать свой таймер на переменную.

Для ясности вашего кода вы всегда должны соответствовать `clearTimeout()` для `setTimeout()` и `clearInterval()` для `setInterval()` .

Чтобы остановить таймер, вызовите соответствующую функцию очистки и передайте ему переменную идентификатора таймера, которая соответствует таймеру, который вы хотите остановить. Синтаксис `clearInterval()` и `clearTimeout()` одинаковый.

Пример:

```javascript
var timeoutID; 
 
 function delayTimer() { 
  timeoutID = setTimeout(delayedFunction, 3000); 
 } 
 
 function delayedFunction() { 
  alert(“Three seconds have elapsed.”); 
 } 
 
 function clearAlert() { 
  clearTimeout(timeoutID); 
 } 

```