---
title: Debugging Node files using CLI commands
localeTitle: Отладка файлов узлов с помощью команд CLI
---
## Отладка файлов узлов с помощью команд CLI

В этом уроке вы узнаете, как вы можете отлаживать код Node.js в командной строке. Ваш простой код JavaScript можно легко отладить с помощью DevTools в браузере. Для узла вы можете отлаживать свой код, не покидая свой интерфейс командной строки (CLI).

Допустим, у вас есть файл с именем `contents.js` . Вы должны запустить файл, используя команду `node` .

```bash
node contents.js 
```

Это многое должно быть уже известно вам, так как вы пишете код Node.js. Теперь любые ошибки, которые появляются, должны быть отлажены. Чтобы запустить файл в режиме отладки, добавьте `inspect` ключевых слов во время запуска файла.

```bash
node inspect contents.js 
```

Теперь эта команда откроет ваш файл в режиме отладки. Здесь вы можете шагнуть через свой код по одной строке за раз, нажав клавишу **N** на клавиатуре.

Отладчик начнется с первой строки. Нажимая **N** , вы можете переместить отладчик на следующую строку. Если в первой строке произошла ошибка, она отобразила бы ошибку вместо перехода ко второй строке. Это очень полезно. Если, например, на 17-й строке есть ошибка, она покажет вам ошибку перед движением вперед.

В вашей логике может быть ошибка, то есть вы хотите, чтобы определенное значение отображалось, но вместо этого оно показывает другое значение. В этом случае добавление `console.log()` s может помочь вам и в режиме отладки, будет легче определить причину ошибки.

* * *

Иногда иногда случается, что ваш исходный код огромен. Вы отправляетесь в режим отладки, чтобы отлаживать свои ошибки, и вы уверены, что ошибка связана с функцией в строке 52. Но поскольку режим отладки начинается с строки 1, у вас нет выбора, кроме как посещать строку 52 по очереди? Точно нет!

Просто добавьте `debugger` ключевых слов перед функцией.

```javascript
console.log("Outside the function....everything's going smoothly"); 
 
 debugger; 
 
 function doesSomething() { 
    //some logic 
    console.log("Something went wrong inside here!"); 
 } 
```

Теперь откройте файл снова в режиме отладки и на этот раз нажмите **C** на клавиатуре.

Нажатие **N** перемещает отладчик на следующую строку, а нажатие **C** указывает отладчику пройти весь код за один раз. Это то же самое, что работать без режима отладки. _Но_ на этот раз ваш код имеет дополнение. Вы догадались - ключевое слово `debugger` . Нажатие кнопки **C** обычно запускает код до конца, но из-за добавления `debugger` он останавливается перед запуском функции.

Поэтому, после запуска вашего файла в режиме отладки, нажатие **C** пропустит код и остановится точно перед функцией по ключевому слову `debugger` . После этого вы можете начать выполнять функцию по одной строке за раз, пока не укажете свою ошибку.