---
title: Iterate with JavaScript for Loops
localeTitle: Итерация с JavaScript для циклов
---
Наиболее распространенный тип цикла JavaScript называется `for loop` , поскольку он работает `for` определенного количества времени.
```
var ourArray = []; 
 for(var i = 0; i < 5; i++) { 
  ourArray.push(i); 
 } 
```

нашArray теперь будет содержать \[0,1,2,3,4\]

## Подробнее о циклах
```
for(var i = 0; i < 5; i++) {  // There are 3 parts here 
```

Для цикла есть три части. Они разделяются точкой с запятой.

1.  Инициализация: `var i = 0;` - Этот код запускается только один раз в начале цикла. Обычно он используется для объявления переменной счетчика (с `var` ) и инициализации счетчика (в этом случае он установлен в 0).
    
2.  Условие: `i < 5;` - Цикл будет работать, пока это `true` . Это означает, что как только `i` будет равно 5, цикл прекратит цикл. Обратите внимание, что внутри цикла никогда не будет видно, что `i` 5, потому что он остановится до этого. Если это условие изначально `false` , цикл никогда не будет выполняться.
    
3.  Инкремент: `i++` - этот код запускается в конце каждого цикла. Обычно это простое приращение (оператор `++` ), но может быть любым математическим преобразованием. Он используется для перемещения счетчика ( `i` ) вперед (или назад или что-то еще).