---
title: Using Anonymous Functions for Private Namespacing in Your JavaScript Apps
localeTitle: Использование анонимных функций для частного пространства имен в ваших приложениях JavaScript
---
Давайте посмотрим, что такое пространство имен, когда дело доходит до создания приложений JavaScript и некоторые преимущества использования частного пространства имен при создании приложений.

**Обратите внимание, что эта статья ссылается на анонимные функции самоисполнения. Если вы не знаете, что это такое, прочитайте эту замечательную статью Ноа Стокса: « [Самостоятельные анонимные функции» или «Как писать чистый Javascript»](http://esbueno.noahstokes.com/post/77292606977/self-executing-anonymous-functions-or-how-to-write) . В этой статье мы подробно рассмотрим анонимные функции самоисполнения.**

## Что такое пространство имен?

Проще говоря, пространство имен - это всего лишь раздел кода, который имеет свое собственное пространство. Когда вы начинаете писать JS-приложения, вы обычно просто вводите код и запускаете его. Это превращает весь код в так называемое **глобальное пространство имен** , которое содержит весь код для окна, в котором вы работаете.

Однако, если вы сохраняете весь свой код в **глобальном пространстве имен** , вы можете столкнуться с проблемами с коллизиями, соглашениями об именах и т. Д., Особенно в крупных JS-приложениях / играх.

Давайте рассмотрим пример того, как использование только **глобального пространства имен** для разработки игры - плохая идея.

Итак, допустим, у нас есть игра, которая отслеживает те моменты, которые у игрока есть:
```
var points = 0; 
```

Множество игр отслеживают точки, чтобы добавить конкурентное преимущество в игру. Просто введя эту строку в скрипт, мы создали переменную с именем _точки_ , которые могут отслеживать число очков , полученных пользователем.

И все хорошо и хорошо, но скажем, что у нас есть более продвинутый пользователь, играющий в игру. Этот пользователь знает, как смотреть на источник веб-страницы, и поэтому этот человек заглядывает в источник, стоящий за игрой JS, и понимает, что переменная _точек_ просто сидит там в **глобальном пространстве имен** . Злая ухмылка спускается по их лицу, когда они размышляют о точках, которые они могут достичь! Они решают, что они не хотят ждать, чтобы победить некоторых злодеев или разбить грибы или что у вас есть, чтобы набрать кучу очков. Они хотят получить очки сейчас! Ну, как звучит _квадриллион миллиардов миллионов_ точек ?! Таким образом, они загружают консоль в свой любимый браузер и просто набирают консоль:
```
points = 34750925489459203859095480917458059034; 
```

Как только пользователь нажимает Enter, переменная _точек_ обновляется в игре. Теперь у пользователя есть действительно громоздкое и, вероятно, нереалистичное количество очков в игре, и он может похвастаться своим друзьям, что никто не может победить его потрясающий результат.

Итак, как мы можем предотвратить это? Именно здесь вступают в действие **частные пространства имен** .

## Частные пространства имен

**Частные пространства имен** позволяют разработчикам помещать свой код в разделы (или **пространства имен** ). Эти разделы работают независимо друг от друга, но могут читать и писать из **глобального пространства имен** .

Чтобы разложить это на более простые условия из сценария реальной жизни, скажем, вы работаете в офисном здании. У вас есть собственный офис, и вы видите других со своими офисами. Каждый офис заблокирован, и только тот, кто владеет офисом, имеет ключ к этому офису. Давайте также скажем, что у вас есть какой-то новый супер-замок, который делает ваш офис непроницаемым для любого другого человека в здании. Рассмотрим офисное здание как **глобальное пространство имен** и каждый офис как **частное пространство имен** . У вас нет доступа в чей-либо офис или у них нет доступа к вашим. Но каждый из вас имеет доступ к остальной части офисного здания, будь то кофе, схватка и т. Д. Каждый из вас может получить что-то из **глобального пространства имен** (или создать / изменить что-то там), но вы можете создавать или изменять / захватывать что-либо из офисов друг друга; вы можете создавать / изменять / захватывать из собственного **частного пространства** / офиса.

## Достижение частного пространства имен

Итак, как нам достичь этого **частного пространства имен** в JavaScript? Используйте анонимную функцию самоисполнения! Если вы не прочитали статью Ноа Стоукса, « [Самопроизвольные анонимные функции» или «Как писать чистый Javascript»](http://esbueno.noahstokes.com/post/77292606977/self-executing-anonymous-functions-or-how-to-write) , сделайте это сейчас. В этой статье мы подробно рассмотрим анонимные функции самоисполнения.

Давайте рассмотрим использование этой переменной _точек_ из ранее, но разделим ее на **частное пространство имен** :
```
//The most common way you'll see an anonymous self-executing function 
 (function () { 
    var points = 0; 
 })(); 
 
 //This is just one of many more alternative ways to use an anonymous self-executing function 
 /* 
 !function () { 
    var points = 0; 
 }(); 
 */ 
```

Теперь, когда пользователь доберется до страницы, они не смогут открыть консоль в своем браузере и изменить значение переменной точек по своему усмотрению! Потрясающие!

## Пространство имен и документов

Вышеприведенный код использовался только для использования анонимной самоисполняющейся функции, чтобы дать коду собственное **частное пространство имен** . Имейте в виду, что пространства имен влияют только на JS-код (переменные / массивы / объекты / etc.), А не на код, который относится к самому документу.

Любой код в пространстве имен по-прежнему имеет одинаковый доступ к HTML-документу и CSS, как обычно в **глобальном пространстве имен** . Взгляните на следующие два примера кода. Они выполняют одну и ту же функциональность, и ни одна из них не является более выгодной или более эффективной, чем другая.
```
<script type="text/javascript"> 
    (function () { 
        document.querySelector('body').style.background = 'blue'; 
    })(); 
 </script> 
```

такой же как:
```
<script type="text/javascript"> 
    document.querySelector('body').style.background = 'blue'; 
 </script> 
```

Имейте в виду, что это всего лишь один из способов использования пространств имен в приложениях JavaScript. Адаптируйте свой код к тому, что наилучшим образом соответствует ситуации.