---
title: Window Confirm Method
localeTitle: Метод подтверждения окна
---
## Метод подтверждения окна

Вы можете использовать метод `confirm` чтобы попросить пользователя дважды проверить решение на веб-странице. Когда вы вызываете этот метод, браузер отобразит диалоговое окно с двумя вариантами в строках «ОК» и «Отмена».

Например, скажем, кто-то просто нажал кнопку «Удалить». Вы можете запустить следующий код:

```javascript
if (window.confirm("Are you sure you want to delete this item?")) { 
  // Delete the item 
 } 
```

Сообщение «Вы действительно хотите удалить этот элемент?» появится в диалоговом окне. Если пользователь нажимает кнопку «ОК», метод подтверждения вернет `true` и браузер запустит код внутри оператора if. Если он или она нажимает Отмена, метод вернет `false` и ничего больше не произойдет. Это обеспечивает некоторую защиту от случайного нажатия кнопки Удалить.

#### Дополнительная информация:

[Документы MDN](https://developer.mozilla.org/en-US/docs/Web/API/Window/confirm)