---
title: Window.localStorage
localeTitle: Window.localStorage
---
## window.localStorage

`localStorage` предоставляет возможность для ваших веб-приложений хранить данные локально в браузере пользователя.

До HTML5 данные приложения должны храниться в файлах cookie. Куки-файлы включены в каждый HTTP-запрос, тем самым замедляя ваше веб-приложение, передавая одни и те же данные. Файлы cookie также ограничены примерно 4 КБ данных, которые могут быть недостаточными для хранения требуемых данных.

Предел `localStorage` больше, чем у файлов cookie с до 10 МБ данных на домен, и информация никогда не передается серверу.

### Типы localStorage

Существует два основных типа сетевых хранилищ:

*   Локальное хранилище: хранит данные без истечения срока действия. Данные в `localStorage` будут сохраняться, даже если браузер пользователя будет закрыт и снова открыт.
*   `localStorage` сеансов: это похоже на `localStorage` , за исключением того, что оно хранит данные только для одного сеанса. Когда пользователь закрыт браузером, этот сеанс будет потерян, а сохраненные данные будут удалены из браузера.

### Методы локального хранилища HTML5

`localStorage` поставляется с несколькими различными методами JavaScript, из-за которых очень легко работать, давайте посмотрим на некоторые:

_Примечание. Эти методы применяются как к типам веб-хранилища (локальное хранилище и хранилище сеансов)_

Чтобы установить данные, нам необходимо сделать следующее:

```javascript
localStorage.setItem('Name', 'somevalue'); 
```

Чтобы получить некоторые данные из хранилища:

```javascript
localStorage.getItem('Name'); 
```

Для удаления или удаления некоторых данных мы можем сделать это:

```javascript
localStorage.removeItem('Name'); 
```

Чтобы очистить все хранилище (а не только отдельный элемент), мы можем использовать:

```javascript
localStorage.clear(); 
```

Чтобы получить количество свойств в хранилище:

```javascript
localStorage.length; 
```

#### Дополнительная информация:

[MDN](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage)