---
title: CSS Method
localeTitle: Метод CSS
---
## Метод CSS

Метод jQuery `.css()` получает значение свойства вычисленного стиля для первого элемента в наборе согласованных элементов или задает один или несколько свойств CSS для каждого согласованного элемента.

### Получение

Чтобы вернуть значение указанного свойства CSS, используйте следующий синтаксис:

```js
    $(selector).css(propertyName); 
```

Например:

```js
    $('#element').css('background'); 
```

Примечание. Здесь мы можем использовать любой селектор css, например: элемент (селектор HTML-тегов), .element (селектор классов), #element (селектор ID).

### настройка

Чтобы установить указанное свойство CSS, используйте следующий синтаксис:

```js
    $(selector).css(propertyName,value); 
```

Например:

```js
    $('#element').css('background','red'); 
```

Чтобы установить несколько свойств CSS, вам нужно использовать синтаксис литерала объекта следующим образом:

```js
    $('#element').css({ 
        'background': 'gray', 
        'color': 'white' 
    }); 
```

Если вы хотите изменить свойство, помеченное более чем одним словом, обратитесь к этому примеру:

Чтобы изменить `background-color` элемента

```js
    $('#element').css('background-color', 'gray'); 
```

#### Дополнительная информация:

Документация: [api.jquery](http://api.jquery.com/css/)