---
title: jQuery Selectors
localeTitle: Селекторы jQuery
---
## Селекторы jQuery

jQuery использует селектор стиля CSS для выбора частей или элементов HTML-страницы. Затем он позволяет вам что-то делать с элементами, использующими методы или функции jQuery.

Чтобы использовать один из этих селекторов, введите знак доллара и круглые скобки после него: `$()` . Это сокращает функцию `jQuery()` . Внутри круглых скобок добавьте элемент, который вы хотите выбрать. Вы можете использовать одиночные или двойные кавычки. После этого добавьте точку после круглых скобок и метод, который вы хотите использовать.

В jQuery селектора классов и идентификаторов похожи на классы в CSS.

Ниже приведен пример метода jQuery, который выбирает все элементы абзаца и добавляет к ним класс «selected»:

```javascript
<p>This is a paragraph selected by a jQuery method.</p> 
 <p>This is also a paragraph selected by a jQuery method.</p> 
 
 $("p").addClass("selected"); 
```

В jQuery селектора классов и идентификаторов те же, что и в CSS. Если вы хотите выбрать элементы с определенным классом, используйте точку ( `.` ) И имя класса. Если вы хотите выбрать элементы с определенным идентификатором, используйте символ хеша ( `#` ) и имя идентификатора. Обратите внимание, что HTML не чувствителен к регистру, поэтому лучше придерживаться разметки HTML и CSS-селекторов в нижнем регистре.

Выбор по классам:

```javascript
<p class="p-with-class">Paragraph with a class.</p> 
 
 $(".p-with-class").css("color", "blue"); // colors the text blue 
```

Выбор по ID:

```javascript
<li id="li-with-id">List item with an ID.</li> 
 
 $("#li-with-id").replaceWith("<p>Socks</p>"); 
```

Вы также можете выбрать определенные элементы вместе со своими классами и идентификаторами:

### Выбор по классам

Если вы хотите выбрать элементы с определенным классом, используйте точку (.) И имя класса.

```html

<p class="pWithClass">Paragraph with a class.</p> 
```

```javascript
$(".pWithClass").css("color", "blue"); // colors the text blue 
```

Вы также можете использовать селектор классов в сочетании с именем тега, чтобы быть более конкретным.

```html

<ul class="wishList">My Wish List</ul>`<br> 
```

```javascript
$("ul.wishList").append("<li>New blender</li>"); 
```

### Выбор по идентификатору

Если вы хотите выбрать элементы с определенным значением идентификатора, используйте символ хеша (#) и имя идентификатора.

```html

<li id="liWithID">List item with an ID.</li> 
```

```javascript
$("#liWithID").replaceWith("<p>Socks</p>"); 
```

Как и в случае с селектором классов, это также можно использовать в сочетании с именем тега.

```html

<h1 id="headline">News Headline</h1> 
```

```javascript
$("h1#headline").css("font-size", "2em"); 
```

### Селекторы, которые действуют как фильтры

Существуют также селекторы, которые действуют как фильтры - они обычно начинаются с двоеточий. Например, `:first` селектор выбирает элемент, который является первым дочерним элементом его родителя. Ниже приведен пример неупорядоченного списка с некоторыми элементами списка. Селектор jQuery под списком выбирает первый элемент `<li>` в списке - элемент списка «Один», а затем использует метод `.css` чтобы превратить текст в зеленый.

```html

   <ul> 
      <li>One</li> 
      <li>Two</li> 
      <li>Three</li> 
   </ul> 
```

```javascript
$("li:first").css("color", "green"); 
```

**Примечание.** Не забывайте, что применение CSS в JavaScript не является хорошей практикой. Вы всегда должны указывать свои стили в файлах css.

Другой селектор фильтрации `:contains(text)` , выбирает элементы с определенным текстом. Поместите текст, который вы хотите совместить в круглых скобках. Вот пример с двумя параграфами. Селектор jQuery берет слово «Moto» и меняет цвет на желтый.

```html

    <p>Hello</p> 
    <p>World</p> 
```

```javascript
$("p:contains('World')").css("color", "yellow"); 
```

Аналогично, `:last` селектор выбирает элемент, который является последним дочерним элементом его родителя. В селекторе jQuery ниже выбирается последний элемент `<li>` в списке - элемент списка «Три», а затем используется метод `.css` чтобы повернуть текст в желтый цвет.

`$("li:last").css("color", "yellow");`

**Примечание.** В селекторе jQuery `World` находится в одинарных кавычках, потому что он уже находится внутри пары двойных кавычек. Всегда используйте одиночные кавычки внутри двойных кавычек, чтобы избежать непреднамеренного окончания строки.

**Несколько селекторов** В jQuery вы можете использовать несколько селекторов для применения одних и тех же изменений более чем к одному элементу, используя одну строку кода. Вы делаете это, разделяя различные идентификаторы запятой. Например, если вы хотите установить цвет фона трех элементов с идентификаторами cat, dog и rat соответственно красным, просто выполните:
```
$("#cat,#dog,#rat").css("background-color","red"); 
```

Это лишь некоторые из селекторов, доступных для использования в jQuery. Дополнительную информацию см. В разделе «Дополнительная информация» на веб-сайте jQuery.

#### Дополнительная информация:

*   [Полный список селекторов jQuery](http://api.jquery.com/category/selectors/)
