---
title: Hello World in Kotlin
localeTitle: Hello World в Kotlin
---
Программа Hello World - очень простая программа, выводящая на экран строку «Hello World!». Она часто используется для отображения основного синтаксиса языка программирования.

В этом уроке мы рассмотрим синтаксис программы Hello World, написанной на Kotlin.

Если вы еще не установили Kotlin, вы должны проверить этот учебник: https://guide.freecodecamp.org/kotlin

## Привет, мир!

```kotlin
// This is a simple Hello World program written in Kotlin 
 
 fun main(args : Array<String>) { 
    println("Hello, World!") 
 } 
```

Как и следовало ожидать, при запуске этой программы на экран выведется сообщение «Hello, World!».

## Синтаксис

### Комментарии
```
// This is a simple Hello World program written in Kotlin 
```

Комментарии - это текст, написанный разработчиком, который добавлен с целью облегчения понимания кода другими разработчиками. Kotlin поддерживает однострочные комментарии (с использованием //) или многострочные комментарии (с использованием / \*\* /).
```
// Single line comment 
 
 /* This is a 
 Multi-line comment 
 */ 
```

### Функция main

```kotlin
fun main(args : Array<String>) {...} 
```

Функция main - обязательная функция, сообщающая компилятору, где он должен начать выполнять наш код. Он принимает массив строк в качестве параметра и возвращает тип ```Unit```, который соответствует типу ```void``` в таких языках, как Java. Как мы видим, функция объявляется с использованием ключевого слова ```fun```, а тело функции должно быть написано внутри фигурных скобок.

Функции без явно объявленного типа возвращаемого значения возвращают тип ```Unit``` , поэтому приведенный выше код эквивалентен этому:

```kotlin
fun main(args : Array<String>): Unit {...} 
```

### Функция println

Функция println принимает строку в качестве аргумента и выводит ее на экран. В этом случае мы печатаем строку «Hello, World!». Обратите внимание, что строковые литералы объявляются с использованием двойных кавычек ```"String"``` .

Если вы хотите узнать больше о синтаксисе Kotlin и начать писать потрясающие программы, советуем открыть потрясающую официальную документацию Kotlin: https://kotlinlang.org/docs/reference/

У меня на этом всё. Надеюсь, что вам понравился этот урок, ура!
