---
title: 10 Simple and Useful Linux Commands
localeTitle: 10 простых и полезных команд Linux
---
# 10 простых и полезных команд Linux

Команды, перечисленные здесь, являются базовыми и помогут вам быстро начать работу. Кроме того, эти команды очень мощные и будут по-прежнему полезны по мере увеличения вашего опыта в Linux.

1.  `echo` Эта команда берет текст, который вы в неё отправляете, и передает его куда-нибудь - обратно на экран, в файл или в другую команду. Пример: `echo "hello!"` Пример № 2: `echo "Hello world" > hello.txt`
2.  `cat` Чтобы отобразить содержимое текстового файла, просто введите `cat myfile` .
3.  `find` Она делает то, что написано (и это хорошо). Используйте её для поиска файлов по пути, размеру, дате, владельцу и множеству других полезных фильтров. Пример: `find . -type f -mtime -1h # List files in this directory modified in the past hour` .
4.  `date` Просто введите "date", когда вы хотите узнать, какое сейчас время. Пример: `date "+It's %l:%m%p on %A"` . Используйте её в скрипте для указания файлов в соответствии с текущей датой.
5.  `ls` Что находится в этом каталоге? Объедините `ls` с некоторыми полезными флагами для отображения и сортировки содержимого каталога по дате и размеру. Он также предоставляет множество опций для форматирования вывода.
6.  `pwd` Где я? Linux может быть неумолимым, особенно когда вы что-то удаляете. Убедитесь, что вы знаете, прежде чем выдавать свои команды.
7.  `mail` Почтовая программа Linux не выглядит хорошо, но она может быть очень полезной. Вы можете создать сообщение и добавить текст, получателей и вложения в одну команду. Пример: `echo "We're having a great time." | mail -s "Wish you were here!" -A postcard.png -t mom@example.com`
8.  `cut` Когда у вас есть строка с разделителями в ней, используйте `cut` для фильтрации определенных полей. Пример: `echo "this, that, and the other" | cut -d, -f2 # "that"`
9.  `grep` Чтобы найти строки текста, содержащие определенную строку, используйте grep. Пример: `grep 'root' /etc/passwd # root:x:0:0:root:/root:/bin/bash`
10.  `sed` Используйте sed, чтобы найти и изменить подстроку в фрагменте текста. Пример: `echo "this, that, and the other" | sed 's/that/those/' # "this, those, and the other"`
11.  `shutdown` use выключите систему и выключите питание. Пример: `shutdown -h now` немедленно отключает систему. `shutdown -h +5` выключает систему через пять минут.
    Для перезагрузки системы с помощью этой же команды, мы используем флаг `-r`. То есть команда `shutdown -r now` без какой-либо отсрочки перезагрузит Вашу систему.

Используйте эти команды в сценариях и в командной строке. Все они очень мощные команды, а справочная страница Linux содержит намного больше информации о каждом из них.

* * *

Кроме того, важными командами, используемыми для системных администраторов, являются:

1.  команда `uptime` Команда Linux uptime показывает, с какой длины ваша система работает, и количество пользователей в настоящее время зарегистрировано, а также отображает среднее значение нагрузки в течение 1,5 и 15 минут.
    
2.  Команда `w` Он отобразит пользователей, которые в настоящее время вошли в систему, и их процесс вместе с показами средней загрузки. также показывает имя входа, имя пользователя, удаленный хост, время входа в систему, время простоя, JCPU, PCPU, команду и процессы.
    
3.  команда `users` Отображаются команды пользователей, которые в настоящее время регистрируются пользователями. У этой команды нет других параметров, кроме справки и версии.
    
4.  `who` командовал которые просто возвращают имя пользователя, дату, время и информацию о хосте. команда которого похожа на команду w. В отличие от команды w, которая не печатает, что делают пользователи. Давайте проиллюстрируем и увидим различные команды who и w.
    
5.  команда `whoami` Команда whoami выводит имя текущего пользователя. Вы также можете использовать команду «кто я» для отображения текущего пользователя. Если вы вошли в систему как root, используя команду sudo, команда «whoami» возвращает root как текущий пользователь. Используйте команду «кто я», если вы хотите знать, что именно пользователь вошел в систему.
    
6.  Команда `ls` Команда ls отображает список файлов в формате для чтения.
    
7.  команда `crontab` Список заданий расписания для текущего пользователя с помощью команды crontab и -l.
    
8.  команда `less` less позволяет быстро просмотреть файл. Вы можете перемещаться вверх и вниз. Нажмите «q», чтобы выйти из меньшего окна.
    
9.  `more` Command more command позволяет быстро просматривать файл и отображать детали в процентах. Вы можете перемещаться вверх и вниз. Нажмите «q», чтобы выйти из большего окна.
    
10.  Команда `cp` Скопируйте файл из источника в пункт назначения, сохраняя тот же режим.
    

Ниже приведен список команд, которые часто используются adiminstrator. Это не полный, но это компактный список команд для ссылки, когда это необходимо.
