---
title: Advantages of Linux
localeTitle: Преимущества Linux
---
## Постоянное и эффективное совершенствование.

Обновления Linux происходят благодаря глобальному сотрудничеству разработчиков. Ошибки документируются и решаются гораздо быстрее с поддержкой такого типа. Кроме того, поскольку разработчики также являются конечными пользователями, у них есть надлежащая мотивация, чтобы удостовериться, что она отвечает потребностям пользователя и что она предназначена для работы хорошо.

## Меньший риск.

Программное обеспечение так же хорошо, как и его поддержка. Представьте себе: часть программного обеспечения создается компанией XYZ, а затем в будущем, они обанкротились или приобрели другую компанию, которая решает сократить свою поддержку. Программное обеспечение никогда не увидит улучшения или исправления, и поэтому его полезность неизбежно подорвет и умрет. Linux принадлежит и управляется ни одной организацией или компанией, поэтому такой ситуации не может быть. Более того, каждый может свободно подбирать его и вносить свой вклад. Риск потери поддержки Linux очень маловероятен из-за его огромной популярности и использования.

## Легкий.

Требования Linux для работы в системе намного ниже, чем для Windows или Mac. При правильном распределении Linux пользователь может иметь скромную настройку, и Linux предоставит системную ценность. Дисковое пространство и площадь памяти также могут быть ниже. Некоторые дистрибутивы подходят для процессоров, относящихся к семейству Pentium, у других есть потребность всего в 128 МБ ОЗУ и примерно столько же для дискового пространства!

## В значительной степени документированы как для новичков, так и для продвинутых пользователей.

Linux имеет активное сообщество тех, кто хочет поделиться своими знаниями и помочь (так же, как FreeCodeCamp!). В Linux есть утилиты командной строки, которые предоставляют документацию о командах, библиотеках, стандартах и ​​т. Д. ( [Страницы Man](https://en.wikipedia.org/wiki/Man_page) и [информационные страницы](https://en.wikipedia.org/wiki/Info_(Unix) ), а также имеется документация, доступная в Интернете в различных форматах, включая [проект документации Linux](http://www.tldp.org/) , [LinuxQuestions](http://www.linuxquestions.org/) , [ServerFault](http://serverfault.com/) , и [Arch Wiki](https://wiki.archlinux.org/) .

В дополнение к документации есть много полезных и гостеприимных сообществ для новичков, чтобы задавать такие вопросы, как [Ask Ubuntu](https://askubuntu.com/) и [Reddit r / linuxquestions](https://www.reddit.com/r/linuxquestions/) .

Имеются самостоятельные сертификаты, которые могут быть приняты, которые распознаются в ИТ-индустрии ( [тесты](https://www.lpi.org) [CompTIA Linux +](https://certification.comptia.org/certifications/linux) и [LPI LPIC](https://www.lpi.org) ). Хотя это не требуется, обучение [C](https://en.wikipedia.org/wiki/C_(programming_language) ) дает возможность пользователю просмотреть код Linux, чтобы увидеть, что они работают.

## Бизнес поддержка.

Мир зависит от Linux, поддерживающего критические системы, поэтому спрос не уходит. Это важно не только тем, кто помогает Linux, но и тем, кто его поддерживает (Вакансии!). Поддержка Linux становится более важной в ИТ, но также знание этих знаний как разработчика сделает их более округлыми и полезными (т.е. [разработчиками Full Stack](https://medium.com/chris-messina/the-full-stack-employee-ed0db089f0a1#.ubttrv255) ).

## Взаимодействие с другими операционными системами.

Linux имеет поддержку драйверов для файловых систем NTFS и HFS + (используется Windows и Mac), а также [Samba](https://www.samba.org/) для поддержки файлов и печати на компьютерах Windows.

## Лучшая аппаратная поддержка.

Для других ОС обычно пользователь должен перейти на веб-сайт производителя, чтобы получить поддержку драйверов для разных типов оборудования. Ядро Linux поддерживает большинство аппаратных средств автоматически через plug-and-play (в основном частично из-за сообщества с открытым исходным кодом). Некоторые производители также разрабатывают версии Linux своих проприетарных драйверов, которые могут быть легко установлены через программный репозиторий дистрибутива или путем ручной установки предоставленных двоичных файлов.

## Доступность программного обеспечения / совместимость.

Linux имеет богатый набор доступных приложений. Он имеет [офисные приложения](https://www.libreoffice.org/discover/libreoffice/) , веб-браузеры ( [Google Chrome](https://www.google.com/chrome/browser/desktop/) и [Mozilla Firefox](https://www.mozilla.org/en-US/firefox/new/) ), [медиаплееры](http://www.videolan.org/vlc/) , обработку [изображений](https://www.gimp.org/) / [видео](http://www.openshot.org/) и т. Д. Для видеоигр [Steam](http://store.steampowered.com/about/) работает в Linux, в котором есть много поддерживаемых игр. Приложения Windows также могут работать в Linux (подробнее см. « [Вино»](https://www.winehq.org/) ).

## Построен для развития.

Поскольку Linux был первоначально создан разработчиками разработчиками, они потратили много времени и сил на совершенствование инструментов, которые они принесут в эксплуатацию. Он имеет мощную [оболочку,](https://en.wikipedia.org/wiki/Unix_shell) которая может использоваться для различных задач программирования и администрирования ( [Bash](https://en.wikipedia.org/wiki/Bash_(Unix_shell) ) - самый популярный и по умолчанию выбор для Linux). Хотя Linux имеет эквивалент «блокнот» в [gedit](https://en.wikipedia.org/wiki/Gedit) , он также предоставляет более мощные и настраиваемые текстовые редакторы, такие как [Vim](https://en.wikipedia.org/wiki/Vim_(text_editor)) ) и [Emacs](https://en.wikipedia.org/wiki/Emacs) (пользователям Linux рекомендуется знать хотя бы один из этих редакторов). Есть также IDE, доступные для веб-разработки, такие как [Atom](https://atom.io/) , [Aptana](http://www.aptana.com/) / [Eclipse](https://eclipse.org/) , [Sublime](https://www.sublimetext.com/) , [KomodoIDE](http://komodoide.com/) , чтобы назвать некоторые из них. Linux также может использовать программное обеспечение, такое как [Apache](https://httpd.apache.org/) для настройки локального веб-сервера для тестирования, [Git](https://git-scm.com/) для управления версиями и другие инструменты / языки, такие как [Node.js](https://nodejs.org/en/) / [Ruby](https://www.ruby-lang.org/en/) / [SaSS](http://sass-lang.com/) / [Heroku,](https://www.heroku.com/) все имеют поддержку в Linux и имеют инструменты командной строки, которые могут вместо графического интерфейса.

## Настраиваемый.

Linux позволяет пользователю изменять дизайн рабочего стола и темы, добавлять виджеты и многое другое. Эти изменения могут быть выполнены в среде рабочего стола. Различные среды имеют разные варианты. Некоторые популярные: KDE, GNOME, XFCE, Pantheon.

## Это бесплатно.

Трудно побить это!