---
title: Basic Linux Commands
localeTitle: Основные команды Linux
---
## Основные команды Linux

Когда вы начинаете работать с Linux, есть некоторые основные команды, которые каждый должен знать.

1.  **cd** - изменить каталог

*   cd, за которым следует каталог или путь к файлу, приведет вас внутрь этого каталога (папки).

2.  команда **ls-** list

*   С помощью команды `ls` можно посмотреть содержимое текущего каталога.
*   `-l` и `-a` два наиболее используемые флаги для команды `ls`, их можно использовать вместе: `ls -la`. Флаг `-l` покажет вам файлы в виде списка и в длинном формате, включая отображение разрешений, `-a` покажет файлы название которых начинается с точки, которые обычно скрыты в GUI-файловом finder, например `.env`-файлы.
*  Порядок флагов не имеет значения, поэтому предыдущая команда может быть записана как ls -al.


3.  **man** - команда для просмотра документации


*   Показывает руководство для следующей команды. Это очень полезно при попытке выяснить, как работает незнакомая команда. Например, введите `man ls` для всего, что вам нужно знать о команде ls. Введите `q` для выхода.

4.  **pwd** - путь

*   Введите `pwd` чтобы отобразить путь к вашему текущему каталогу.

5.  **mkdir** - создать каталог

*   Эта команда, за которой следует имя, которым вы хотите назвать ваш каталог, создает новый каталог. `mkdir folder1` создаст новый каталог с именем folder1.

6.  **rmdir** - удалить каталог

*   Удаляет каталог, следующий за командой. `rmdir folder1` удалит каталог с именем folder1, если он существует.

7.  **rm** - удалить

*   Эта команда удаляет файлы, а не каталоги. `rm file.txt` удалит файл с именем file.txt до тех пор, пока он существует и находится в текущем каталоге.

8.  **touch** - создает файл

*   Команда touch используется для создания файла. Это может быть что угодно: от пустого txt-файла до пустого zip-файла. «touch new.txt» создаст новый файл с именем new.

9.  **mv** - перемещение

*   Используйте команду mv для перемещения файлов через командную строку. Мы также можем использовать команду mv для переименования файла. Например, если мы хотим переименовать файл «текст» в «новый», мы можем использовать «mv текст новый».


10.  **правая кнопка мыши** - скопируйте и вставьте


*   Это, по сути, меньше, чем команда, но, тем не менее, она очень полезна для выполнения почти ничего в терминале Linux. Для начала выделите текст, как обычно, а затем щелкните правой кнопкой мыши, чтобы скопировать выделение. Вы должны видеть, что выделенная часть становится не выделенной, это означает, что вы скопировали выделение. Теперь «щелкните правой кнопкой мыши», где вы хотите вставить выделение, и все готово.


11.  **less** - просмотр содержимого файла

*   Используйте `less filename.txt` для просмотра содержимого файла и перемещения по ниму. По умолчанию `less` показывает файл страница за страницей.

12. **cat** - отображение текстового содержимого файла

* Используйте эту команду для отображения текста из заданного файла на вашем терминале. Ввод `cat myFile.txt` в ваш терминал отобразит содержимое файла` myFile.txt` на экране. Команда `cat` может быть очень удобным инструментом при использовании с терминалом _pipes_.

13. **clear** - очистить терминал

* Используйте `clear`, чтобы просто удалить весь вывод с вашего терминала.

14. **cp** - копировать файлы и каталоги
 
 * Используйте «cp», чтобы скопировать файл или файл с файлами внутри него в другое место, используя команду «cp CURRENT FILE-LOCATION DESTINATION FOLDER». Добавьте флаг '-a', чтобы скопировать каталог, который не пуст.
 
 
### Полезные ресурсы для практики:

- [JSLinux](https://bellard.org/jslinux/vm.html?url=https://bellard.org/jslinux/buildroot-x86.cfg): Запустите терминал в своем браузере. Отлично подходит для практики.
- [LearnShell](https://www.learnshell.org/): Интерактивные учебные пособия по Linux (терминалу).
- [LinuxJourney](https://linuxjourney.com/lesson/the-shell): Коллекция уроков удобных для начинающих.


