---
title: Linux Booting Process
localeTitle: Процесс загрузки Linux
---
# Процесс загрузки Linux - шестиэтапный описательный процесс

Операционная система определяется как низкоуровневое программное обеспечение, которое поддерживает основные функции компьютера, такие как задачи планирования и управление периферийными устройствами. OS удерживает эти 6 этапов высокого уровня типичного процесса загрузки Linux.

![меры](https://raw.githubusercontent.com/Ayushverma8/tech-interview-handbook/master/LinuxBootingProcess.jpg)

### 1\. BIOS

*   BIOS означает базовую систему ввода / вывода
*   Выполняет некоторые проверки целостности системы на жестком диске
*   Ищет, загружает и выполняет программу загрузчика, в основном в основной загрузочной записи (MBR)
*   Он ищет загрузчик на дискете, компакт-диске или жестком диске. Мы можем нажать клавишу (обычно F12 F2, но это зависит от вашей системы) во время загрузки BIOS, чтобы изменить последовательность загрузки.
*   После того, как программа загрузчика обнаружена и загружена в память, BIOS дает ей контроль.
*   Итак, простым языком BIOS загружает и выполняет загрузку MBR

### 2\. MBR

*   MBR означает главную загрузочную запись.
*   Он расположен в 1-м секторе загрузочного диска. Обычно / dev / hda, или / dev / sda. Почему это sda и hda? см. здесь для получения дополнительной информации.
*   Размер MBR меньше 512 байт. У этого есть три компонента: 1) первичная информация загрузчика в 1 446 байт; 2) информация таблицы разделов в следующих 64 байтах; 3) проверка проверки mbr в последних 2 байтах.
*   Он содержит информацию о GRUB (или LILO в старых системах).
*   Итак, простым языком MBR загружает и запускает загрузчик GRUB.

### 3\. GRUB

*   Он расположен в 1-м секторе загрузочного диска. Обычно / dev / hda, или / dev / sda. Почему это sda и hda? см. здесь для получения дополнительной информации.
*   Если в вашей системе установлено несколько изображений ядра, вы можете выбрать, какой из них выполнить, по умолчанию загружается только основной.
*   GRUB отображает заставку, ждет несколько секунд, если вы ничего не вводите, он загружает образ ядра по умолчанию, как указано в файле конфигурации grub.
*   GRUB знает о файловой системе (более старый загрузчик Linux LILO не понимал файловую систему).
*   Конфигурационным файлом Grub является /boot/grub/grub.conf (/etc/grub.conf - ссылка на это). Ниже приведен пример grub.conf CentOS.
```
#boot=/dev/sda 
 default=0 
 timeout=5 
 splashimage=(hd0,0)/boot/grub/splash.xpm.gz 
 hiddenmenu 
 title CentOS (2.6.18-194.el5PAE) 
          root (hd0,0) 
          kernel /boot/vmlinuz-2.6.18-194.el5PAE ro root=LABEL=/ 
          initrd /boot/initrd-2.6.18-194.el5PAE.img 
```

### 4\. Ядро

*   Устанавливает корневую файловую систему, как указано в «root =» в файле grub.conf
*   Ядро выполняет программу / sbin / init
*   Это первая программа, выполняемая ядром Linux, у нее есть идентификатор процесса (PID) 1. Сделайте «ps -ef | grep init 'и проверьте pid. Вы также можете использовать netstat
*   initrd означает Начальный RAM-диск.
*   initrd используется ядром как временная корневая файловая система, пока не загружается ядро ​​и не монтируется реальная корневая файловая система. Он также содержит необходимые драйверы, скомпилированные внутри, что помогает ему получить доступ к разделам жесткого диска и другому оборудованию.

### 5\. Init

*   Посмотрите файл / etc / inittab, чтобы решить уровень выполнения Linux.
    
*   Ниже приведены доступные уровни запуска
    
*   0 - остановка
    
*   1 - Однопользовательский режим
    
*   2 - многопользовательский, без NFS
    
*   3 - Полный многопользовательский режим
    
*   4 - неиспользованный
    
*   5 - X11
    
*   6 - перезагрузка
    
*   Init определяет начальный уровень по умолчанию из / etc / inittab и использует это для загрузки всей соответствующей программы.
    
*   Выполните «grep initdefault / etc / inittab» в вашей системе, чтобы определить уровень выполнения по умолчанию
    
*   Если вы хотите попасть в проблему, вы можете установить уровень запуска по умолчанию на 0 или 6. Поскольку вы знаете, что означает 0 и 6, возможно, вы этого не сделаете.
    
*   Обычно вы устанавливаете уровень запуска по умолчанию на 3 или 5.
    

### 6\. Программы уровня

*   Когда система Linux загружается, вы можете увидеть запуск различных служб. Например, он может сказать «начать sendmail .... ХОРОШО". Это программы уровня запуска, выполняемые из каталога уровня выполнения, как определено вашим уровнем выполнения.
*   В зависимости от настроек уровня инициализации по умолчанию система будет выполнять программы из одного из следующих каталогов.
*   Уровень выполнения 0 - /etc/rc.d/rc0.d/
*   Уровень выполнения 1 - /etc/rc.d/rc1.d/
*   Уровень выполнения 2 - /etc/rc.d/rc2.d/
*   Уровень выполнения 3 - /etc/rc.d/rc3.d/
*   Уровень выполнения 4 - /etc/rc.d/rc4.d/
*   Уровень выполнения 5 - /etc/rc.d/rc5.d/
*   Уровень выполнения 6 - /etc/rc.d/rc6.d/
*   В каталогах /etc/rc.d/rc\*.d/ вы увидите программы, начинающиеся с S и K.
*   Программы запускаются с S, которые используются во время запуска. S для запуска.
*   Программы запускаются с использованием K во время выключения. K для убийства.
*   В названиях программ есть числа справа от S и K. Это порядковый номер, в котором программы должны быть запущены или убиты.