---
title: How to download files using the "wget" utility in Linux
localeTitle: Как загрузить файлы с помощью утилиты wget в Linux
---
## Как загрузить файлы с помощью утилиты wget в Linux

Эта статья представляет собой краткое руководство по использованию утилиты `wget` в ОС на базе Unix. GNU Wget - бесплатная утилита для неинтерактивной загрузки файлов из Интернета. Он поддерживает протоколы HTTP, HTTPS и FTP, а также поиск через HTTP-прокси.

### Установка `wget`

Утилита wget является свободно доступным пакетом и лицензируется в соответствии с лицензией GNU GPL. Эта утилита может быть установлена ​​на любой Unix-подобной ОС, включая Windows и MacOS.

### Основной синтаксис

Основной синтаксис `wget` - это ...
```
wget [option]... [URL]... 
```

### Подробная информация о wget
```
wget --version 
```

```
wget --help 
```

### Загрузка одного файла
```
wget http://ftp.gnu.org/gnu/wget/wget-1.5.3.tar.gz 
```

### Загрузка с FTP
```
wget ftp://ftp.gnu.org/gnu/wget/wget-1.10.1.tar.gz.sig 
```

### Ограничить ограничения скорости загрузки
```
wget --limit-rate=100k http://ftp.gnu.org/gnu/wget/wget-1.5.3.tar.gz 
```

Вы можете играть с оставшимися функциями утилиты `wget`