---
title: How to Use SFTP to Securely Transfer Files with a Remote Server
localeTitle: Как использовать SFTP для безопасной передачи файлов с удаленного сервера
---
## Как использовать SFTP для безопасной передачи файлов с удаленного сервера

Эта статья представляет собой краткое руководство по использованию безопасного протокола передачи файлов (SFTP) для обмена файлами с сервером. Это полезно для программирования, поскольку оно позволяет вам кодоваться и тестировать локально, а затем отправлять свою работу на сервер, когда вы закончите.

### Тестирование SSH

Если вы еще этого не сделали, проверьте, что вы можете использовать SSH на сервере. SFTP использует протокол Secure Shell (SSH), поэтому, если вы не можете использовать SSH, вы, вероятно, тоже не сможете использовать SFTP.

```unix
ssh your_username@hostname_or_ip_address 
```

### Начало сеанса SFTP

Он использует тот же синтаксис, что и SSH, и открывает сеанс, в котором вы можете передавать файлы.

```unix
sftp your_username@hostname_or_ip_address 
```

Чтобы указать полезные команды:

```unix
help 
```

### Перенос файлов и папок

Чтобы загрузить файл:

```unix
get <filename> 
```

Чтобы загрузить папку и ее содержимое, используйте флаг «-r» (также работает для загрузки):

```unix
get -r <foldername> 
```

Чтобы загрузить файл:

```unix
put <filename> 
```

### Изменить папки

Чтобы изменить локальную папку:

```unix
lcd <path/to/folder> 
```

Чтобы изменить удалённую папку:

```unix
cd <path/to/folder> 

```