---
title: Installing CLI Tools Developers Should not Live Without on Linux and Mac
localeTitle: Установка инструментов CLI Разработчики не должны жить без Linux и Mac
---
Эта статья представляет собой краткое описание того, как устанавливать утилиты командной строки ключей, которые разработчики используют каждый день в средах Macintosh и Linux. Основными инструментами CLI, которые будут показаны, являются: Homebrew (Mac), Node и NPM, Bower, Gulp, Grunt и Tmux.

## Установка Homebrew (системы Macintosh)

Homebrew - «Отсутствует менеджер пакетов для OS X». Это отличный инструмент для загрузки и установки пакетов прямо из командной строки. Это не требуется в дистрибутивах Linux, потому что у них уже установлены менеджеры пакетов по умолчанию, такие как `apt-get` или `pacman` . Чтобы установить Homebrew, просто вставьте в терминал следующую команду:

*   `/usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"`

В случае, если вы запустили «Инструменты командной строки Xcode», используйте для установки:

*   `xcode-select --install`

## Установка NPM

`NPM` или Node Package Manager - еще один полезный менеджер пакетов для загрузки в основном веб-инструментов. Загрузка `NPM` также установит инфраструктуру Node.js.

### Mac:

*   Использование типа `Homebrew` : должен быть установлен `brew install node` `NPM` и `NPM` .

### Linux:

*   Использование `apt-get` первого типа: `curl -sL https://deb.nodesource.com/setup_6.x | sudo -E bash -` , затем `sudo apt-get install nodejs`
*   Использование типа `pacman` : `pacman -S nodejs npm`
*   Использование типа `yum` : `sudo yum install nodejs npm`
*   Использование типа `dnf` : `sudo dnf install nodejs`
*   Использование `zypper` типа: `sudo zypper install nodejs6`

## Установка Bower

Bower - популярный менеджер пакетов, который позволяет устанавливать интерфейсные библиотеки. Вы можете установить его на Linux и Macintosh с помощью `npm` с помощью следующей команды:

*   `npm install -g bower` (та же команда для Linux и OS X)

## Установка Gulp

`Gulp` - это структура и инструмент CLI, который делает разработку более быстрой и приятной благодаря автоматизации задач, которые разработчики задач выполняют, и снова. Кроме того, вы можете установить `Gulp` через `npm` :

*   `npm install -g gulp-cli`

И в отдельных папках проекта:

*   `npm install --save-dev gulp`

## Установка Grunt

`Grunt` - еще один популярный инструмент автоматизации, подобный `Gulp` . Чтобы установить его, снова используйте `npm` :

*   `npm install -g grunt-cli`

## Установка Tmux

`Tmux` - это терминальный мультиплексор для Linux и Mac. Это дает вам возможность иметь несколько сеансов и окон в одном окне Bash, а также позволяет «отсоединять» сеансы, с которыми вы можете подключаться через SSH, оставляя все запущенные и запущенные программы.

Для установки на Linux:

*   `sudo apt install tmux`

И это все! Благодаря этим инструментам ваш процесс разработки и контент будут приятными и эффективными. Как вы можете видеть, основным инструментом для установки является `npm` и он позволяет устанавливать многие другие удобные инструменты для веб-ориентированных CLI.