---
title: Origins of Linux and the Free Software Movement
localeTitle: Происхождение Linux и движение свободного программного обеспечения
---
В 1980-х годах известный хакер MIT, работающий в лаборатории искусственного интеллекта [Ричард Столлман,](https://en.wikipedia.org/wiki/Richard_Stallman) способствовал свободному обмену знаниями и идеями, особенно в области программного обеспечения. [UNIX](https://en.wikipedia.org/wiki/Unix) - это [операционная система](https://en.wikipedia.org/wiki/Operating_system) (ОС), которую многие выбрали в инженерном и научном сообществе, но проблема была в том, что UNIX была [проприетарным программным обеспечением](https://en.wikipedia.org/wiki/Proprietary_software) . Это означало, что только поставщики ОС имели доступ к [исходному коду](https://en.wikipedia.org/wiki/Source_code) . Это противоречило философии Сталлмана. Это означало не только то, что конечным пользователям не разрешалось видеть, как работает программное обеспечение, они не могут делать никаких улучшений или исправлений, если бы могли.

Stallman основал [Free Software Foundation](https://en.wikipedia.org/wiki/Free_Software_Foundation) (FSF), который поддерживал идеалы [свободного программного обеспечения](https://en.wikipedia.org/wiki/Free_software_movement) (люди, которые используют и совместно содействуют открытому и бесплатному программному обеспечению). Он также отвечал за запуск [проекта GNU](https://en.wikipedia.org/wiki/GNU_Project) в 1984 году, который был первой попыткой бесплатной ОС, которая не была UNIX (GNU является [рекурсивным аббревиатурой](https://en.wikipedia.org/wiki/Recursive_acronym) для «GNUs not UNIX»). Проект GNU будет включать все полезные, найденные в системе UNIX, но написанные с нуля. Что еще более важно, вместе с ОС исходный код также был бы законным для тех, кто этого хотел. Идея заключалась в том, что свободный обмен исходным кодом и внутренним знанием ОС стимулировал бы совместную разработку, которая, в свою очередь, создавала бы более совершенный продукт ОС. Проект GNU в конечном итоге привел к [публичной лицензии GNU](https://en.wikipedia.org/wiki/GNU_General_Public_License) (GPL), которая легализовала все выпущенные под нее программное обеспечение, чтобы они были свободно доступны, а также требовали предоставления исходного кода. Хотя GPL был успешным и до сих пор используется для лицензирования бесплатного программного обеспечения, проект GNU никогда не снимался, как планировалось. Другой хакер вмешался и предоставил ему вместо этого бесплатную операционную систему.

[Линус Торвальдс](https://en.wikipedia.org/wiki/Linus_Torvalds) , финский студент из Хельсинского университета, сначала создал [ядро](https://en.wikipedia.org/wiki/Linux) Linux, экспериментируя со свободной и меньшей версией UNIX, используемой в образовательных целях [MINIX,](https://en.wikipedia.org/wiki/MINIX) разработанной [Эндрю Танебатумом](https://en.wikipedia.org/wiki/Andrew_S._Tanenbaum) . Линус хотел иметь такую ​​же свободную ОС, которая не имела ограничений на то, чтобы быть ограниченным чисто образовательным использованием. Он создал Linux, который он лицензировал в GPL и распространялся в Интернете в 1991 году (Текущий исходный код и работа над ядром Linux можно найти [здесь, в](https://github.com/torvalds/linux) GitHub. Linus не использовал какой-либо код из MINIX, но он включил найденные функции в MINIX / UNIX, поэтому Linux часто называют [«UNIX-подобным»](https://en.wikipedia.org/wiki/Unix-like) или «UNIX-клоном».

Несмотря на то, что GNU Project никогда не создавал полноценную бесплатную ОС, он создал много системного программного обеспечения для взаимодействия с ядром, которое жизненно важно для хорошо функционирующей ОС. Таким образом, комбинация ядра Linux и основных системных программ GNU сделала возможной полностью бесплатную ОС.

Со временем Linux начал собирать сильную тягу в рамках движения свободного программного обеспечения. Тысячи разработчиков по всему миру начали экспериментировать и использовать его, делая вклады там, где они сочли нужным. По мере того как он стал более стабильным и многофункциональным, предприятия постепенно начали использовать Linux в качестве решения для своих нужд и даже начали вносить свой вклад в Linux. В настоящее время Linux достигает множества устройств и сред и продолжает расти в популярности.