---
title: Shell scripting
localeTitle: Сценарии оболочки
---
# Сценарии оболочки

В командной строке сценарий оболочки является исполняемым файлом, который содержит набор инструкций, которые будет выполняться оболочкой. Основная цель - уменьшить набор инструкций (или команд) только в одном файле. Также он может обрабатывать некоторая логика, потому что это язык программирования.

## Как его создать

1) Создайте файл:

```bash
$ touch myscript.sh 
```

2) Добавьте [shebang](https://en.wikipedia.org/wiki/Shebang_(Unix)) в начале файла. Строка Shebang отвечает за то, что интерпретатор команд знает, с каким интерпретатором будет запускаться скрипт оболочки:

```bash
$ echo "#!/bin/bash" > myscript.sh 
 # or 
 $ your-desired-editor myscript.sh 
 # write at the first line #!/bin/bash 
```

3) Добавьте несколько команд:

```bash
$ echo "echo Hello World!" >> myscript.sh 
```

4) Дайте режим _выполнения_ файла:

```bash
$ chmod +x myscript.sh 
```

5) Выполните его!

```bash
$ ./myscript.sh 
 Hello World! 
```

Подробнее о shell-скриптинге можно найти [здесь](https://www.shellscript.sh/)