---
title: The Anatomy of the Linux Command Line
localeTitle: Анатомия командной строки Linux
---
# Анатомия командной строки Linux

В этом высокотехнологичном мире с графическим интерфейсом (GUI) команда многих компьютерных пользователей находят идею ввода текстовых команд (в командной строке или терминале) для выполнения основных функций как отталкивающих - и их лучше всего оставить для программистов или разработчики (на самом деле вундеркинды).

К счастью, интерфейс командной строки (CLI) является королем в мире Linux. Несмотря на то, что многие приставки linux имеют хорошо отполированные и интуитивно понятные графические интерфейсы, для оптимального использования Linux все еще нужно знакомство с CLI Linux (терминалом или оболочкой), чтобы быстро и чисто выполнять основные компьютерные операции.

Командная строка по-прежнему играет очень важную роль в жизни пользователя Linux и вашего пользователя, если вы решите его использовать.

В Linux команды выдаются (набираются) в терминале. Хотя терминальное приложение может иметь разные имена в разных дистрибутивах Linux (дистрибутивы), но в большинстве случаев это просто называется терминалом или близким термином.

Чтобы начать использовать открытый терминал (для Ubuntu просто удерживайте Ctrl + Alt + T), и вас приветствует серия символов, расположенных в этом формате;

```linux
user_name@machine_name:~$ 
```

Вы можете увидеть командную строку, заканчивающуюся мигающим приглашением оболочки, означающее, что оболочка готова к приему команд от пользователя.

*   Имя пользователя **_«_** user\_name **_»_** отображает имя пользователя.
    
*   **_«Имя\_компьютера»_** (также называемое доменным именем) - это имя, назначенное компьютеру (или серверу), и оно обычно устанавливается во время установки. Иногда он также может быть представлен IP-адресом.
    
*   Знак тильды **_«~»_** показывает, что текущий каталог пользователя является его «домом» `(/home/user_name)` .
    
    *   Обратите внимание, что каждый пользователь в системе Linux имеет для них каталог HOME, и этот домашний каталог всегда имеет одно и то же имя с именем пользователя (или именем пользователя). То есть, если имя пользователя «john», то его домашним каталогом будет / home / john. При входе в систему каждый пользователь берется непосредственно в свой домашний каталог.

С командного терминала вы можете начать выдавать команду оболочке. Несколько команд могут быть заданы в одной командной строке, используя разделяющую их точку с запятой. Что-то вроде этого;

`user_name@machine_name:~$ who; free; df`

Но в большинстве случаев для обеспечения чистой выписки желательно вводить команды по одному, чтобы не кластеризовать экран.