---
title: The Command Prompt
localeTitle: Командная строка
---
## Командная строка

В качестве одного из старейших пользовательских интерфейсов (UI) _командная строка_ (aka _shell_ , _terminal_ , _console_ , _tty_ ) была реализована многими способами.

Это привело к тому, что несколько слов использовались взаимозаменяемо в современном разговоре, которые фактически имеют несколько разные значения.

* * *

> Оглавление

*   [Очень, очень короткая история](#a-very-very-short-history)
*   [сегодня](#today)
*   [Оболочка](#the-shell)
*   [BASH](#bash)
*   [Получать помощь](#getting-help)
*   [Подсказка](#the-prompt)
*   [Получение корня](#getting-root)
*   [авторизоваться](#login)
*   [Судо](#sudo)
*   [су](#su)
*   [Относительные и абсолютные пути](#relative-and-absolute-paths)
*   [Родственник](#relative)
*   [абсолют](#absolute)
*   [Параметры команды](#command-options)
*   [Цеповые команды](#chaining-commands)
*   [Справочные задания](#background-jobs)

* * *

### Очень, очень короткая история

В XIX веке был [телеграф](https://en.wikipedia.org/wiki/Electrical_telegraph) . Это позволило двум людям обменяться закодированными сообщениями на большие расстояния. Позже технологические достижения привели к тому, что [машина телетайпа](https://en.wikipedia.org/wiki/Teleprinter) (tty), где человек, который должен был получить сообщение, был заменен своего рода принтером.

В то же время ранние компьютеры, такие как ENIAC, были запрограммированы с помощью какого-то оборудования, например коммутаторов, циферблатов или патч-кабелей. По мере того, как компьютеры продвигались вперед, требовалось лучше вводить / выводить (IO), и поэтому широко используемые телетайп-машины были преобразованы для использования.

Потому что tty были крупными предметами мебели сами по себе и заработали **консоль** имен для их сходства с другой напольной мебелью, такой как консольные телевизоры. В качестве электронной конечной точки для мейнфрейма эти устройства также назывались **терминалами** .

TTY-принтеры в конечном итоге были заменены экранами на основе катода Ray Tube (CRT), которые также использовались в телевизорах до того, как были доступны LCD и плазмы. Интересно, что современные компьютеры Linux все еще можно контролировать с помощью машины tty!

> Нажмите на изображение ниже, чтобы перейти к короткому видео Youtube.

[![](https://i.ytimg.com/vi/-Ul-f3hPJQM/hqdefault.jpg)](https://youtu.be/-Ul-f3hPJQM)

* * *

### Cегодня

Сегодня пользователи Linux и Unix по-прежнему используют одни и те же термины, но с небольшими различиями. Доступны реальные и виртуальные терминалы, а к виртуальным терминалам можно получить доступ с помощью Alt + Ctrl + \[F1-F12\] .

В графических пользовательских средах (GUI) пользователи могут получить доступ к командной строке с помощью **эмулятора терминала** , который предоставляет функции tty, но внутри окна. Для пользователей Linux доступно множество эмуляторов терминалов, таких как **xterm** , **kterm** и **rxvt** .

Доступные из них будут зависеть от того, какой дистрибутив Linux (дистрибутив, для краткости) вы используете, и его значения по умолчанию. Обратитесь к менеджеру пакетов, чтобы установить другие. Пользователи Windows могут использовать **PuTTY** или другие утилиты для подключения к системе Linux.

### Оболочка

_Shell_ s - это программы, которые интерпретируют команды.

Их несколько, таких как [**B** ourne **A** gain **SH** ell](https://www.gnu.org/software/bash/) (BASH), [C Shell](https://docs.freebsd.org/44doc/usd/04.csh/paper.html) (csh / tcsh) и [Z SHell](http://zsh.sourceforge.net/) (zsh).

#### BASH

Наиболее распространенной оболочкой по умолчанию в Linux является BASH, но каждый пользователь может временно или постоянно переключаться на любую другую доступную оболочку. Оболочка полностью доступна для сценариев, что означает, что концепции программирования можно комбинировать с оболочками и системными утилитами для создания более сложных функций.

Команды, введенные в командной строке, могут быть встроены в оболочку, например, **cd** , **exit** или **export** .

Они также могут поступать из внешних программ, а в случае большинства дистрибутивов Linux - с помощью [инструментов Gnu](https://www.gnu.org/software/coreutils/coreutils.html) .

Ниже приведены наиболее распространенные команды.

| Команда | Использование | | -------- | ----------------------------------------- | | `cd` | изменить текущий каталог | | `ls` | список файлов в текущем каталоге | | `mv` | перемещать файлы и каталоги | | `man` | открытая командная документация | | `mkdir` | создать каталог | | `rmdir` | удалить директора | | `touch` | создать пустой файл | | `rm` | удалить файлы | | `ln` | создавать ссылки на файлы и каталоги | | `chown` | изменить право собственности на файлы и каталоги | | `chmod` | изменить разрешения | | `find` | найти файлы | | `cat` | записывает файлы в стандартный вывод | | `less` | позволяет прокручивать стандартный вход | | `grep` | поиск матчей в текстовом формате | | `diff` | показать различия между файлами | | `passwd` | изменить пароль |

#### Получать помощь

Немедленная помощь доступна для команд в одном или нескольких местах.

Добавить `--help` после команды.

Это печатает информацию об использовании для этой команды.

Его результат аналогичен команде `man` , но `man` используется перед командой, для которой вы хотите руководство.

Команда `info` - это третий вариант справки, который используется как `man` .

```bash
ls --help 
 
 man ls 
 
 info ls 
```

### Подсказка

Запрос, представляющий собой бит текста в оболочке слева от курсора, может измениться, чтобы отобразить текущий статус, например каталог, в котором вы сейчас находитесь, какого пользователя вы вошли в систему, имя вашего компьютера и _что привилегии, которые у вас есть_ .

Последнее важно осознать. Обычно последний символ в подсказке, вы увидите значение `$` , которое указывает на обычные пользовательские привилегии.

Если у вас есть права **root** , принадлежащие системному администратору, вы обычно увидите `#` в качестве последнего символа. При просмотре форумов и получении помощи в Интернете команды, которые вы должны вводить, часто будут показаны с этим символом.

**Вам не нужно вводить его!**

Например:

```bash
$ ls -l 
```

означает, что вы `ls -l` в обычном приглашении.

```bash
# apt-get install node 
```

означает, что вы `apt-get install node` с правами администратора. Как вы повышаете свои привилегии, зависит от вашего дистрибутива Linux.

### Получение корня

#### авторизоваться

Вход в систему как root - _очень плохая идея_ . Вот почему некоторые версии Linux отключают возможность пользователей регистрироваться таким образом. Этим пользователям предлагается использовать следующий метод `sudo` из своей учетной записи пользователя.

Если вам нужно использовать корневую консоль, помните о ее мощности. Вы не будете предупреждены или попросите подтвердить большинство задач, даже если простая опечатка означает удаление чего-то важного.

#### Судо

Добавьте «sudo» перед командой, чтобы переключиться на **S** uper **U** ser и **DO** (SUDO). Вот как Ubuntu и его производные настроены так, чтобы разрешить доступ администратора, и предоставляется по каждой команде.

Вам не назначена корневая оболочка, и следующая команда, которую вы вводите, не будет иметь повышенных привилегий, если вы не будете повторно использовать `sudo` .

```bash
sudo apt-get update 
```

За исключением первого созданного пользователя на определенных дистрибутивах, пользователи должны быть добавлены в специальный список (найденный в `/etc/sudoers` ), чтобы использовать sudo.

Это делается с помощью команды `visudo` .

Вы никогда не должны редактировать файл `sudoers` с помощью обычного текстового редактора!

`visudo` будет следить за тем, чтобы вы не блокировали себя из своей собственной системы.

#### су

`su` , как и `sudo` , позволяет вам переключиться на другого пользователя, за исключением того, что по умолчанию вы получите другое приглашение в качестве пользователя, к которому вы переключились.

По своему усмотрению `su` переключит вас в корневое приглашение, но с переменными среды текущего пользователя, такими как `$HOME` для вашей домашней папки и `$PATH` для системного пути.

Это может привести к неожиданным результатам, и если вы хотите использовать `su` для переключения на другого пользователя, добавьте дефис после команды:

```bash
su - 
```

Это полностью переключит вас на корневую подсказку.

Пользовательское имя может быть добавлено в команду для переключения на этого пользователя, но для этого потребуется пароль пользователя.

`sudo` можно использовать в сочетании с `su` чтобы администратор мог переключиться на любого пользователя.

```bash
myUser@linux $ su - otherUsername 
 Password: (typed my password) 
 su: Authentication failure 
 
 myUser@linux $ sudo su - otherUsername 
 Password: (typed my password) 
 otherUsername@Linux $ 
```

### Относительные и абсолютные пути

При использовании команды в файле, например, при копировании или удалении, вы можете ссылаться на файл одним из двух способов.

#### Родственник

Расположение файла по отношению к текущему каталогу.

В оболочке есть два относительных оператора пути `.` и `..`

Первый, `.` означает текущий каталог, поэтому `cat file.txt` и `cat ./file.txt` - это то же самое, если file.txt находится в текущем каталоге.

Другой - это `..` и означает один каталог в дереве.

Поэтому, если вы находитесь в `/home/user/projects/project-a` и выпустите команду `cd ..` вы измените на `/home/user/projects` .

Если в каталоге проектов есть подкаталоги с именем `project-a` , `project-b` , `project-c` , и вы были в каталоге `project-a` , вы можете переключиться на `project-b` используя `cd ../project-b` .

Существует также `environment variable` в оболочке с именем `$HOME` которая указывает на ваш домашний каталог.

Вы можете использовать это в BASH, используя символ тильды `~` .

Оболочка заменяет тильду для вас, когда вы нажимаете enter, поэтому, например, вы можете перейти в свою домашнюю домашнюю папку с помощью `cd ~` .

#### абсолют

Расположение файлов - это полный путь от корня файловой системы и всегда имеет ведущую косую черту.

Например, `cd /home/quincy/Desktop` перейдет в рабочий каталог Quincy, независимо от текущего пути или зарегистрированного пользователя.

### Параметры команды

Большинство команд оболочки соответствуют одному и тому же синтаксису, который является **файлом параметров команд** .

```bash
ls -l *.txt 
```

где

*   `ls` дает список файлов и каталогов,
*   `-l` изменяет вывод `ls` на длинный список,
*   и `*.txt` ограничивает список файлами, заканчивающимися на `.txt` .

Каждая команда имеет разные параметры, и несколько параметров могут быть перечислены вместе, как в tar- `tar -cvf` в следующем разделе.

Отдельные команды могут быть соединены вместе в цепочке, где вывод одной команды становится входом другой команды.

Это делается с помощью `|` характер, часто называемый **трубой** или **баром** . Это не капитал I или нижний регистр L , и это не номер 1 . На американских клавиатурах он находится на одном из ключей возле Enter .

В следующем примере я буду использовать 2 команды.

Первая, `cat` , короткая для конкатенации и может быть использована для размещения содержимого одного файла в конце другого (конкатенация!). При использовании только одного файла он записывает содержимое в терминал.

Вторая команда `grep` - это программа, которая выводит текст, найденный на основе некоторого ввода, и шаблон поиска. Шаблон поиска может быть простым текстом или регулярным выражением (регулярное выражение) для более сложных поисковых запросов.

```bash
cat index.html | grep img 
```

Существует много способов сделать это, но это будет выводить каждую строку в index.html, которая содержит `img` для терминала. В этом примере используется только один `|` , но вы не ограничиваетесь этим.

### Цеповые команды

Хотя единственный оператор амперсанда `&` является оператором управления заданиями в BASH (следующий раздел), двойной амперсанд имеет другое значение. Это логично **И** , и вы используете его между двумя командами, чтобы вторая команда выполнялась только в том случае, если первый из них успешно завершен (без ошибок).

Следующий пример: сколько пользователей Debian и Ubuntu обновляют свой список программ, а затем запускают обновление системы.

```bash
sudo apt-get update && sudo apt-get dist-upgrade 
```

Другим вариантом является двойная труба `||` , что означает логическое **ИЛИ** . Вы будете использовать его, если хотите запустить команду, только когда первый выход с ошибкой.

Следующее создаст архив под названием `project.tar` на рабочем столе пользователя из файлов в каталоге проекта, а если это не удастся, эхо-сообщение.

```bash
tar -cvf /home/user/Desktop/project.tar /home/user/project/* || echo "archive failed" 
```

### Справочные задания

Когда вы выполняете команду в терминале, терминал занят до тех пор, пока команда не будет завершена, и никакие другие команды не будут запущены. В Linux есть система управления заданиями, которая позволяет приостановить выполнение команд, возобновить приостановленные команды в фоновом режиме и возобновить приостановленные команды на переднем плане.

Это полезно для длинных сценариев, или когда вам нужно нажимать что-то на задний план, чтобы терминал можно было использовать для других вещей.

o приостановить программу, которая работает в терминале, используйте комбинацию клавиш Ctrl + Z.

Вы вернетесь к своему обычному запросу, и команда, похоже, ушла. Это не так, но было приостановлено. Он по-прежнему отображается в списке заданий, используя команду `jobs` чтобы отображать все текущие отслеживаемые задания. Я сделал `man ls` чтобы получить страницу руководства, а затем приостановил ее.

Когда я печатаю `jobs` я получаю следующий результат:

```bash
$ jobs 
 
 [1]  + suspended  man ls 
```

Отсюда я могу возобновить его в фоновом режиме, набрав `bg %1` где `1` - номер задания, найденный в квадратных скобках.

Я могу вернуть его на передний план, набрав `fg %1` .