---
title: Using the Find Command
localeTitle: Использование команды «Найти»
---
# Использование команды «Найти»

Команда поиска Linux - это мощный инструмент, который поможет вам находить файлы и каталоги на вашем сервере. С небольшой практикой вы можете легко отслеживать вещи на основе имени, типа, размера или даты (когда они были созданы или обновлены в последний раз).

Подумайте о том, как найти своего горячего помощника:

Вы: «Я что-то искал на своем сервере».

Найдите: «Я могу помочь! Что вы можете рассказать мне об этом?»

Вы: «Это был файл размером более 2 ГБ, где-то под моим домашним каталогом, обновленный за последние 48 часов».

Найдите: «Тада!»

Найти программу, так что вам действительно нужно сказать, что она `find ~ -type f -size +2G` .

Вот несколько примеров команд, использующих find:

*   `find ~ -type d # Show me all the subdirectories inside my home directory`
*   `find / -type f -name 'todo.txt' # Show me files named 'todo.txt' anywhere under the root directory (ie anywhere)`

Первый параметр всегда указывает каталог, в котором мы будем смотреть. В приведенных выше примерах это ~ (домашний каталог текущего пользователя) и / (корневой каталог файловой системы).

Другие параметры являются необязательными и могут быть объединены в любом удобном для вас способом:

*   Параметр type позволяет вам ограничивать поиск только файлов (f), только каталогов (d) или символических ссылок (l). Если вы опустите параметр типа, вы будете искать все эти типы.
*   Параметр name позволяет указать, что вы хотите найти по имени, либо с литеральной строкой ('filename.txt'), либо с помощью подстановочных знаков ('file?. \*').

`man find` покажет вам еще много параметров и заслуживает рассмотрения. Найти можно найти файлы по имени, пользователю, дате создания, размеру и многим другим. В следующий раз, когда вы что-то ищете, найдите его!