---
title: Writing a Bash Script
localeTitle: Написание сценария Bash
---
# Написание сценария Bash

Набрав команды в командной строке Linux, вы можете дать командам сервера выполнение некоторых простых задач. Как ад скрипт - это способ собрать ряд инструкций, чтобы сделать это проще. Сценарии оболочки становятся еще более мощными, когда вы добавляете логику, как `if` и `while` автоматически определяли, как они себя ведут при изменении обстоятельств.

## Что такое Баш?

Bash - это имя интерпретатора командной строки, программа, которая имеет смысл команд Linux, которые вы вводите в команде или в вашем скрипте.

## Что в скрипте?

Скрипт - это всего лишь файл. Основной сценарий состоит из вводной строки, которая сообщает серверу, что с ней делать, и один или больше инструкций для выполнения. Вот пример:
```
#!/bin/bash 
 echo "Hi. I'm your new favorite bash script." 
```

Первая строка имеет особое значение, о чем мы поговорим ниже. Вторая строка - это только команда Linux, которую вы можете ввести в командной строке.

## Что такое комментарий?

Комментарии - это текст, который вы добавляете в свой скрипт, который вы намерены игнорировать bash. Комментарии начинаются с знака фунта и полезны для аннотируя ваш код, чтобы вы и другие пользователи могли его понять. Чтобы добавить комментарий, введите `#` символ, за которым следует любой текст это вам полезно. Bash игнорирует `#` и все после него.

**Примечание:** первая строка скрипта не является комментарием. Эта строка всегда первая, всегда начинается с `#!` и имеет специальные смысл для bash.

Вот сценарий от ранее, прокомментировал:
```
#!/bin/bash # Designates the path to the bash program. Must start with '#!' (but isn't a comment). 
 echo "Hi. I'm your new favorite bash script." # 'echo' is a program that sends a string to the screen. 
```

## Выполнение скрипта

Вы можете открыть текстовый редактор, вставить этот примерный код и сохранить файл, и у вас есть скрипт. Скрипты условно named, заканчивающийся на '.sh', поэтому вы можете сохранить этот код как myscript.sh.

Сценарий не будет выполняться, пока мы не сделаем 2 вещи:

**Во-первых, сделайте его исполняемым.** (Мы будем делать это только один раз.) Linux широко использует разрешения на доступ к файлам. Они многое определяют, как ведет себя ваш сервер. Многому нужно знать о разрешений, но пока нам нужно только знать это: вы не можете запускать свой скрипт, пока не получите права на выполнение. к сделайте это, введите:

`chmod +x my script.sh`

**Во-вторых, запустите его.** Мы выполняем сценарий из командной строки, как и любую другую команду, например `ls` или `date` . Сценарий name - это команда, и вам нужно будет предшествовать ей «./», когда вы ее вызываете:

`./myscript.sh # Outputs "Hi. I'm your new favorite bash script." (This part is a comment!)`

## Conditionals

Иногда вы хотите, чтобы ваш скрипт что-то делал, только если что-то еще верно. Например, напечатайте сообщение, только если значение ниже определенного предела. Вот пример использования, `if` необходимо сделать:
```
#!/bin/bash 
 
 count=1 # Create a variable named count and set it to 1 
 
 if [[ $count -lt 11 ]]; then # This is an if block (or conditional). Test to see if $count is 10 or less. If it is, execute the instructions inside the block. 
    echo "$count is 10 or less" # This will print, because count = 1. 
 fi # Every if ends with fi 
```

Аналогичным образом, мы можем организовать сценарий, чтобы он выполнял инструкцию только в том случае, если что-то истинно. Мы изменим код так, чтобы значение переменной счетчика изменяется:
```
#!/bin/bash 
 
 count=1 # Create a variable named count and set it to 1 
 
 while [[ $count -lt 11 ]]; do # This is an if block (or conditional). Test to see if $count is 10 or less. If it is, execute the instructions inside the block. 
    echo "$count is 10 or less" # This will print as long as count <= 10. 
    count=$((count+1)) # Increment count 
 done # Every while ends with done 
```

Результат этой версии myscript.sh будет выглядеть так:
```
"1 is 10 or less" 
 "2 is 10 or less" 
 "3 is 10 or less" 
 "4 is 10 or less" 
 "5 is 10 or less" 
 "6 is 10 or less" 
 "7 is 10 or less" 
 "8 is 10 or less" 
 "9 is 10 or less" 
 "10 is 10 or less" 
```

## Сценарии реального мира

Эти примеры не очень полезны, но принципы. Используя `while` , `if` и любую команду, которую вы в противном случае могли бы ввести вручную вы можете создавать сценарии, которые выполняют ценную работу.