---
title: Algebra of Logic
localeTitle: Алгебра логики
---
## Алгебра логики

_Алгебра логики_ или _булева алгебра_ является ветвью математики. Он имеет дело с переменными и их значением истины. Переменные имеют два возможных состояния: `true` или `false` .

Он был впервые представлен Джорджем Булом в его книге «Математический анализ логики» (1847).

Булева алгебра фундаментальна для развития цифровой электроники. Он отвечает за то, чтобы сделать все современные вычисления.

Три основные операции в булевой алгебре - это `AND` , `OR` и `NOT` . Рассмотрим две булевы переменные `x` и `y` :

*   `x AND y` истинно тогда и только тогда, когда оба `x` и `y` верны
*   `x OR y` истинно тогда и только тогда, когда любое из `x` , `y` истинно. Если `x` , `y` оба истины, `x OR y` по-прежнему верен
*   `NOT x` является истинным тогда и только тогда, когда `x` является ложным и наоборот

### Дополнительная информация:

*   Исчисление логики: [Джордж Бул](http://www.maths.tcd.ie/pub/HistMath/People/Boole/CalcLogic/CalcLogic.html)
*   Статья с булевой алгеброй: [Википедия](https://en.wikipedia.org/wiki/Boolean_algebra)
