---
title: Dining Philosophers Problem
localeTitle: Обеденные проблемы философов
---
## Обеденные проблемы философов

В информатике проблема столовых философов - примерная проблема, часто используемая в параллельном дизайне алгоритмов, чтобы проиллюстрировать проблемы синхронизации и методы их решения. Первоначально он был сформулирован в 1965 году Эдсгером Дейкстра в качестве студенческого экзамена, представленного с точки зрения компьютеров, конкурирующих за доступ к периферийным устройствам стримера. Вскоре после этого Тони Хоар поставил проблему своей нынешней формулировкой.

Говоря простыми словами, проблема столовых философов - это иллюстрация того, как синхронизированный доступ к общему ресурсу может привести к созданию ситуации взаимоблокировки.

#### Синхронизация и взаимоблокировка

**Синхронизация** используется для управления одновременным доступом к общему ресурсу. Это необходимо в любой ситуации, когда несколько независимых участников могут конкурировать за использование одного ресурса. Поскольку имеется только один доступный ресурс, мы используем синхронизацию для предотвращения путаницы и хаоса.

**Тупик** - это системное состояние, в котором прогресс невозможен. Эта ситуация может возникнуть при принудительной синхронизации, и многие процессы ожидают общий ресурс, который удерживается каким-либо другим процессом. В этом случае процессы просто ждут и не выполняются дальше.

#### Постановка задачи

Пять тихих философов сидят за круглым столом с чашами спагетти. Вилки расположены между каждой парой смежных философов.

Каждый философ должен поочередно думать и есть. Однако философ может есть только спагетти, когда у них есть левая и правая вилки. Каждая вилка может удерживаться только одним философом, и поэтому философ может использовать вилку, только если ее не использует другой философ. После того, как индивидуальный философ закончит есть, им нужно сложить обе вилки, чтобы вилки стали доступны другим. Философ может взять вилку по правую или одну по левую, когда они становятся доступными, но не может начать есть, прежде чем получить обе вилки. ( **Синхронизация** )

Потребление пищи не ограничено оставшимися количествами спагетти или желудочного пространства; предполагается бесконечное предложение и бесконечный спрос.

Проблема заключается в том, как разработать дисциплину поведения (параллельный алгоритм), чтобы ни один философ не голодал; т.е. каждый может навсегда продолжать чередование между едой и мышлением, предполагая, что ни один философ не может знать, когда другие захотят есть или думать. ( **Отказ от тупика** )

На начальном этапе может показаться, что тупик не всегда возможен. Чтобы убедиться, что правильное решение этой проблемы не является очевидным, рассмотрите предложение, в котором каждому философу поручено вести себя следующим образом:

1.  подумайте, пока левая вилка не будет доступна; когда это произойдет, забрать его;
2.  подумайте, пока не появится правая вилка; когда это произойдет, забрать его;
3.  когда обе вилки удерживаются, ешьте в течение фиксированного количества времени;
4.  затем положите правую вилку вниз;
5.  затем положите левую вилку вниз;
6.  повторите с самого начала.

Это попытка не срабатывает, поскольку она позволяет системе достичь состояния взаимоблокировки, при котором прогресс невозможен. Это состояние, в котором каждый философ поднимает вилку влево и ждет, когда вилка станет доступной, или наоборот. С помощью этих инструкций это состояние может быть достигнуто, и когда это будет достигнуто, философы будут вечно ждать друг друга, чтобы выпустить вилку. ( **Тупик и голод** )

Существует множество решений по предотвращению взаимоблокировки. Если мы посмотрим внимательно, одна из проблем в вышеприведенном алгоритме состоит в том, что все философы имеют равную вероятность (имеют тот же приоритет) приобретения одной вилки. Это не позволяет кому-либо приобрести две вилки, и вся система остановится.

Решения включают: -

1.  Приоритет. Некоторым философам присваивается более высокий приоритет, так что вероятность приобретения обеих вилок увеличивается.
2.  Предотвращение (вежливость). Философы отказываются от приобретенной вилки без еды, если другая вилка недоступна.
3.  Арбитраж. Посредник выделяет вилки, обеспечивающие, чтобы две вилки были предоставлены одному человеку, и один из них был одним из многих.

#### Дополнительная информация:

https://www.wikiwand.com/en/Dining _философы_ проблема