---
title: Logical Operators
localeTitle: Логические операторы
---
## Логические операторы

**А ТАКЖЕ (&&)**  
A && B возвращает True, если оба A и B являются True. Если A или B (или оба) являются False, то A && B является False.

| A | B | AND (A, B) | | --- | --- | --- | | е | t | f | | е | f | f | | т | t | t | | т | f | t |

**OR (||)**  
A || B возвращает значение True, если A или B (или оба A и B) имеют значение True. Возвращает только False, если оба A и B являются False.

| A | B | OR (A, B) | | --- | --- | --- | | е | t | t | | е | f | f | | т | t | t | | т | f | t |

**НЕ (!)**  
Возвращает противоположное значение. Ex. если A истинно, то A является ложным, а если A является ложным, то! A истинно. Это единственный логический оператор, который работает только на одном входе, что делает его унарным оператором.

| A | B | NOT (A) | НЕ (B) | --- | --- | --- | --- | | е | t | t | f | | е | f | t | t | | т | t | f | f | | т | f | f | t |

**XOR ("eXclusive или")**  
Известен как **эксклюзивный или** . Подобно OR, но возвращает False, если оба A и B истинны. То есть, XOR возвращает true, если один и только один из A или B - True.

| A | B | XOR (A, B) | | --- | --- | --- | | е | t | t | | е | f | f | | т | t | f | | т | f | t |

**Последствия (A -> B)**  
Читайте как «если A, затем B» или «A подразумевает B». Возвращает только False, когда A истинно, а B - False. В противном случае подразумевается True.  
![](http://sites.millersville.edu/bikenaga/math-proof/truth-tables/truth-tables13.png)

Примечание. Последствия часто используются для прямых математических доказательств. A представляет собой гипотезу, а B - заключение.

Единственный раз, когда условие является ложным, - это когда истинное значение приводит к ложному значению.

| A | B | IF (A, B) | | --- | --- | --- | | е | t | t | | е | f | t | | т | t | t | | т | f | f |

**Логическая эквивалентность (iff: тогда и только тогда, когда)**  
«P тогда и только тогда, когда Q» совпадает с «P означает, что Q AND Q означает P». Другими словами, таблицы истинности для P и Q идентичны для всех значений истинности. Это известно как biconditional. Это эквивалентно A -> B **И** B-> A. Это означает, что оба условия должны быть выполнены для того, чтобы biconditional был истинным.

Вы можете легко видеть, что выходной вывод IFF-оператора в таблице истинности аналогичен идентификатору столбцов 3 и 4.

| A | B | IF (A, B) | IF (B, A) | IFF (A, B) | | --- | --- | --- | --- | --- | | е | t | t | f | f | | е | f | t | t | t | | т | t | t | t | t | | т | f | f | t | f |

#### Дополнительная информация:

\+ \* [Логические операторы в Javascript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_Operators) + \* [Логические операторы в PHP](http://php.net/manual/en/language.operators.logical.php) + \* [Логические операторы в C ++](http://en.cppreference.com/w/cpp/language/operator_logical)