---
title: Monty Hall Problem
localeTitle: Проблема Монти Холла
---
## Проблема Монти Холла

Проблема Монти Холла - загадка вероятности, названная в честь хозяина 70-х, показывает, что она основана на «Давайте сделаем сделку». Эта конкретная проблема - это верный парадокс. Это означает, что есть решение, которое кажется противоречащим интуиции, но доказано, что это правда.

Задача определяется следующим образом: Вы играете в игру, и есть 3 двери, каждая из которых имеет другой приз. За одной из трех дверей стоит машина. У двух других есть козы. Вы должны выбрать одну из трех дверей для выбора в качестве своего приза. Скажите, что вы выбрали дверь 1, но перед открытием двери Монти решает открыть Дверь 2, которая показывает козу. Теперь он спрашивает, хотите ли вы вместо этого выбрать «дверь 3». Если вы выбираете дверь 3 по своему первоначальному выбору? Это даже имеет значение?

Оказывается, выбор имеет значение, и на самом деле вам в свою очередь нужно переключить свое решение на дверь 3! Вот почему. Когда вы выбрали Дверь 1 из 3 закрытых дверей, у вас был шанс 1 из 3, что вы выбрали правильный. У обеих дверей 2 и двери 3 также есть 1 из 3 шансов иметь автомобиль за ним. Вы также можете сказать, что у дверей 2 и 3 есть 2 из 3 шансов иметь автомобиль за ним _вместе взятый_ .

![Probability before revealing a goat](https://i.imgur.com/8EsVvZk.png "Вероятность до выявления козы")

Теперь, когда хост открывает Дверь 2 и содержит козу, теперь у вас больше информации о проблеме. Помните, что двери 2 и 3 имеют комбинированную вероятность, содержащую автомобиль 2 / 3rds того времени. С открытием двери вы знаете, что у двери 2 нет автомобиля. Но это выявление не изменяет объединенной вероятности двух дверей. Это ключевой вынос здесь! Поскольку мы теперь знаем, что у двери 2 есть 0/3 шанс показать автомобиль, теперь вы можете сказать, что у двери 3 есть шанс 2 / 3rds содержать автомобиль. Сочетание вероятностей двери 2 и двери 3 все еще добавляет до 2 / 3rds, как это было до открытия двери 2. Дверь 1 остается неизменной и имеет только 1/3-й шанс. Таким образом, если вы решите переключиться, вы переходите от примерно 33.33% к 66.67% от выбора автомобиля. Другими словами, вы удваиваете свои шансы на успех, переключаясь!

![Probability after revealing a goat](https://i.imgur.com/V2JzAka.png "Вероятность выявления козы")

Да, возможно, что у двери 1 была машина, и Монти обманул тебя. Это не имеет значения. Вы играете в азартные игры, беря сделку, но вы играете в азартные игры. Вы принимаете самое лучшее решение с информацией, которую вы даете, и пусть бросок кости. В конечном счете вы выполняете лучшее переключение, чем участник, который решает сохранить свой первый выбор. В конце концов, Монти действительно обманывает себя, предлагая вам лучшее дело.

#### Дополнительная информация:

[Проблема Монти Холла - Numberfile](https://www.youtube.com/watch?time_continue=1&v=4Lb-6rxZxx0)

[21 Проблема Кевина Спейси Монти Холла](https://www.youtube.com/watch?v=YReov4c3taI)

#### Дополнительная информация:

*   Тема проблемы Монти Холла: [Википедия](https://en.wikipedia.org/wiki/Monty_Hall_problem)