---
title: Truth Tables
localeTitle: Таблицы правды
---
## Таблицы правды

Таблица истинности - математический инструмент, используемый в булевой алгебре. Он состоит из столбца для переменных функции. В последнем столбце содержится функциональное значение, оцененное для соответствующих значений переменных. Для булевой функции из n переменных его расширение таблицы истинности будет иметь 2 ^ n строк. Это означает, что каждая переменная имеет два возможных состояния - true & false.

### А ТАКЖЕ

Давайте рассмотрим таблицу истинности для оператора И:

| x | y | x И y | | --- | --- | --- | | F | F | F | | F | T | F | | T | F | F | | T | T | T |

И является двоичным оператором. Он работает на двух переменных, например `x` , `y` .

Таким образом, мы имеем 2 ^ 2 = 4 столбца в нашей таблице истинности!

Последний столбец - это функциональное значение - x AND y. Логика для операции И состоит в том, что если значения x и y являются только Истинными, тогда выход будет иметь значение True, иначе это будет False.

Аналогично таблицы истинности для других логических операторов -

### НЕ

| x | НЕ Х | | --- | --- | | F | T | | T | F |

### ИЛИ

| x | y | x OR y | | --- | --- | --- | | F | F | F | | F | T | T | | T | F | T | | T | T | T |

### XOR

| x | y | x XOR y | | --- | --- | --- | | F | F | F | | F | T | T | | T | F | T | | T | T | F |

OR:

| x | y | x OR y | | --- | --- | --- | | F | F | F | | F | T | T | | T | F | T | | T | T | T |

НЕ оператор:

| x | НЕ х | | --- | --- | | F | T | | T | F |

Оператор действия:

| x | y | x IMPLY y | | --- | --- | --- | | F | F | T | | F | T | T | | T | F | F | | T | T | T |

Оператор импликации часто может смущать некоторых. Полезно связать примеры реального мира, чтобы помочь пониманию этого оператора. Например, рассмотрим: Если идет дождь, я пользуюсь зонтиком. Здесь, полагая, что идет дождь, я пользуюсь зонтиком (утверждение выполнено) Но если идет дождь, и я не использую зонтик, тогда утверждение не выдерживает. Несмотря на это, если не идет дождь, и я все еще пользуюсь зонтиком, то это утверждение также имеет место (на самом деле не имеет значения, используется ли зонт или нет, поскольку не идет дождь, хотя это выглядело бы довольно странно).

Тем не менее, оператор импликации может быть озадачен для предполагаемых предложений, которые являются ложными в реальном мире. Рассматривать: Если солнце сделано из воды, то 1 + 1 = 3. Согласно таблице истинности истинности эта пропозициональная формула истинна.

P означает, что Q также можно рассматривать как аббревиатуру для NOT (P) ИЛИ Q.

Оператор двойной импликации:

| x | y | x <-> y | | --- | --- | --- | | F | F | T | | F | T | F | | T | F | F | | T | T | T |

Таблицы истины являются мощным инструментом. Они могут использоваться для выражения и оценки простых булевых функций и операций, сложных комбинационных схем и последовательных логических схем!

Вот таблица истинности оператора OR

| x | y | x OR y | | --- | --- | --- | | F | F | F | | F | T | T | | T | F | T | | T | T | F |

Как и выше оператор OR работает с двумя переменными, обратите внимание, что единственный раз, когда оператор OR оценивает значение True, это когда `x` & `y` отрицать друг друга.

Давайте сделаем еще один, давайте сделаем таблицу для Negation, это работает на одном значении, а не на двух

| x | НЕ х | | --- | --- | | T | F | | F | T |

Это правило проще и просто отрицает исходное значение `x`

#### Дополнительная информация:

*   [Гиперфизика - Государственный университет Грузии](http://hyperphysics.phy-astr.gsu.edu/hbase/Electronic/truth.html)
*   [Википедия](https://en.wikipedia.org/wiki/Truth_table)