---
title: Backpropagation
localeTitle: обратное распространение ошибки
---
## обратное распространение ошибки

Backprogapation - это подтема [нейронных сетей](../neural-networks/index.md) и процесс, посредством которого вы вычисляете градиенты каждого узла в сети. Эти градиенты измеряют «ошибку», каждый из которых вносит вклад в выходной уровень, поэтому при обучении нейронной сети эти градиенты минимизируются.

Примечание. Backprogapation требует знание линейной алгебры. Курсовая работа или чтение статей по этой тематике настоятельно рекомендуется, прежде чем пытаться понять содержание данной статьи.

### Вычисление 

Процесс обратного распространения можно объяснить тремя шагами.

Учитывая следующее

*   m учебных примеров (x, y) на нейронной сети из L-слоев
*   g = сигмоидальная функция
*   Theta (i) = матрица перехода от i-го до i + 1-го слоя
*   a (l) = g (z (l)); массив значений узлов в слое l на основе одного примера обучения
*   z (l) = Theta (l-1) a (l-1)
*   Delta - набор L-матриц, представляющих переходы между i-м и i + 1-м слоем
*   d (l) = массив градиентов для слоя l для одного примера обучения
*   D набор L-матриц с окончательными градиентами для каждого узла
*   лямбда - термин регуляризации для сети

В этом случае для матрицы M будет обозначать транспонирование матрицы M

1.  Назначьте все записи Delta (i), для i от 1 до L, ноль.
2.  Для каждого примера обучения t от 1 до m выполните следующие действия:

*   выполнить прямое распространение на каждом примере для вычисления a (l) и z (l) для каждого слоя
*   вычисление d (L) = a (L) - y (t)
*   вычисление d (l) = (Theta (l) '• d (l + 1)) • g (z (l)) для l из L-1 в 1
*   приращение Delta (l) на delta (l + 1) • a (l) '

1.  Подключите матрицу Delta к нашим частным производным матрицам D (l) = 1 \\ m (Delta (l) + lambda • Theta (l)); если l ≠ 0 D (l) = 1 \\ m • Delta (l); если l = 0

Конечно, просто просмотр этой статьи выглядит чрезвычайно сложным и должен действительно пониматься только в более широких контекстах нейронных сетей и машинного обучения. Посмотрите на дополнительные ссылки для лучшего понимания темы.

#### Дополнительная информация:

*   [Лекция 4 CS231n Введение в нейронные сети](https://youtu.be/d14TUNcbn1k?t=354)
*   [Сирадж Равал - Пролонгация через 5 минут](https://www.youtube.com/watch?v=q555kfIFUCM)
*   [Курс Эндрю Нг](https://www.coursera.org/learn/machine-learning/)
*   [В глубине статьи в стиле вики](https://brilliant.org/wiki/backpropagation/)
*   [Backprop в Википедии](https://en.wikipedia.org/wiki/Backpropagation)
*   [Пример поэтапного обратного прогона](https://mattmazur.com/2015/03/17/a-step-by-step-backpropagation-example/)
