---
title: Clustering Algorithms
localeTitle: Алгоритмы кластеризации
--- # Алгоритмы кластеризации

Кластеризация - это процесс деления данных на отдельные группы (кластеры), гарантируя, что:

*   Каждый кластер содержит похожие объекты
*   Объекты, которые не принадлежат к тем же кластерам, не похожи

Алгоритмы кластеризации помогают находить структуру в коллекции немаркированных данных и попадают в категорию обучения без учителя.

Трудность заключается в определении меры подобия, которая может отделять данные так, как вы хотите. Например, группу лиц можно разделить по полу, цвету волос, весу, расе и т. Д.

Алгоритмы кластеризации группируют набор объектов таким образом, что объекты в одной и той же группе (кластере) более схожи (в том или ином смысле) друг с другом, чем с другими группами (кластерами). Это основная задача поискового анализа данных и общий метод анализа статистических данных. Он используется во многих областях, включая компьютерное обучение, распознавание образов, анализ изображений, поиск информации, биоинформатику, сжатие данных и компьютерную графику.

Некоторые приложения алгоритмов кластеризации включают в себя:

*   Группировка потребителей в соответствии с их паттернами покупки
*   Группировка фотографий животных одного вида
*   Классификация документов разных типов

## Типы алгоритмов кластеризации:

1.  Кластеризация на основе соединений (иерархическая кластеризация)
2.  Кластеризация на основе центра или точки (кластеризация k-средних)
3.  Кластеризация на основе распределения
4.  Кластеризация на основе плотности

Некоторые примеры алгоритмов кластеризации:

1.  Аггломерирующая кластеризация
2.  Кластеризация K-средних
3.  Кластеризация K-медоидов
4.  Кластеризация разделов

### Иерархическая кластеризация

Существуют методы кластеризации, которые используют только сходства экземпляров, без каких-либо других требований к данным; цель состоит в том, чтобы найти группы, так что экземпляры в группе более похожи друг на друга, чем экземпляры в разных группах. Это подход, используемый иерархической кластеризацией.

Это требует использования сходства или эквивалентного расстояния, определенного между экземплярами. Обычно используется евклидово расстояние, где нужно убедиться, что все атрибуты имеют одинаковый масштаб.

### Назначение точек

Этот метод поддерживает набор кластеров и помещает точки в ближайшие кластеры.

## Специальные алгоритмы кластеризации

### Кластеризация K-средних

Алгоритм K-средних является популярным алгоритмом кластеризации, поскольку он относительно прост и быстр, в отличие от других алгоритмов кластеризации. Алгоритм определяется следующим образом:

1.  Определить входной параметр k (количество кластеров)
2.  Выберите k случайных точек данных для использования в качестве центроидов
3.  Вычислить расстояния для всех точек данных для каждого k центроидов и назначить каждую точку данных кластеру, содержащему ближайший центроид
4.  После того как все точки данных были классифицированы, вычислите среднюю точку всех точек для каждого кластера и назначьте их как новый центр тяжести
5.  Повторите шаги 3 и 4, пока центроиды не сходится в определенных k точках.

Поскольку нам нужно только вычислить расстояния kxn (а не n (n-1) расстояния для алгоритма knn), этот алгоритм достаточно масштабируемый.

Вот пример кластеризации в Python, который использует [набор данных Iris](https://www.kaggle.com/uciml/iris)

```python
import pandas as pd 
 import numpy as np 
 iris = pd.read_csv('Iris.csv') 
 del iris['Id'] 
 del iris['SepalLengthCm'] 
 del iris['SepalWidthCm'] 
 
 from matplotlib import pyplot as plt 
 # k is the input parameter set to the number of species 
 k = len(iris['Species'].unique()) 
 for i in iris['Species'].unique(): 
    # select only the applicable rows 
    ds = iris[iris['Species'] == i] 
    # plot the points 
    plt.plot(ds[['PetalLengthCm']],ds[['PetalWidthCm']],'o') 
 plt.title("Original Iris by Species") 
 plt.show() 
 
 from sklearn import cluster 
 del iris['Species'] 
 kmeans = cluster.KMeans(n_clusters=k, n_init=10, max_iter=300, algorithm='auto') 
 kmeans.fit(iris) 
 labels = kmeans.labels_ 
 centroids = kmeans.cluster_centers_ 
 
 for i in range(k): 
    # select only data observations from the applicable cluster 
    ds = iris.iloc[np.where(labels==i)] 
    # plot the data observations 
    plt.plot(ds['PetalLengthCm'],ds['PetalWidthCm'],'o') 
    # plot the centroids 
    lines = plt.plot(centroids[i,0],centroids[i,1],'kx') 
    # make the centroid x's bigger 
    plt.setp(lines,ms=15.0) 
    plt.setp(lines,mew=2.0) 
 plt.title("Iris by K-Means Clustering") 
 plt.show() 
```

Поскольку точки данных принадлежат обычно высокомерному пространству, мера подобия часто определяется как расстояние между двумя векторами (евклидовым, манхатаном, косином, махаланобисом ...)

### Плотность смеси

Мы можем написать _плотность смеси_ как: ![плотность смеси](https://latex.codecogs.com/gif.latex?p%28x%29%20%3D%20%5Csum_%7Bi%3D1%7D%5E%7Bk%7Dp%28x%7CG_%7Bi%7D%29p%28G_%7Bi%7D%29) где Gi - компоненты смеси. Их также называют группой или кластерами. p (x | Gi) - плотность компонент, а P (Gi) - пропорции смеси. Число компонентов, k, является гиперпараметром и должно быть указано заранее.

### Ожидание-максимизация (EM)

В этом подходе вероятностно, и мы ищем параметры плотности компонента, которые максимизируют вероятность выборки.

Алгоритм ЭМ является эффективной итерационной процедурой для вычисления оценки максимального правдоподобия (ML) при наличии отсутствующих или скрытых данных. В оценке ML мы хотим оценить параметр (ы) модели, для которого наиболее вероятными являются наблюдаемые данные.

Каждая итерация ЭМ-алгоритма состоит из двух процессов: Э-шаг и М-шаг.

1.  В ожидании или E-шаге недостающие данные оцениваются с учетом наблюдаемых данных и текущей оценки параметров модели. Это достигается с помощью условного ожидания, объясняющего выбор терминологии.
2.  На М-шаге функция правдоподобия максимизируется в предположении, что недостающие данные известны. Оценка отсутствующих данных с E-шага используется вместо фактических отсутствующих данных.

Конвергенция гарантируется, поскольку алгоритм гарантированно увеличивает вероятность на каждой итерации.

## Дополнительная информация:

*   [Статья аналитика кластера Википедии](https://en.wikipedia.org/wiki/Cluster_analysis)
*   [Введение в кластеризацию и связанные с ней алгоритмы](https://www.analyticsvidhya.com/blog/2016/11/an-introduction-to-clustering-and-different-methods-of-clustering/)
*   [Алгоритмы кластеризации - Стенды Стэнфордского университета](https://web.stanford.edu/class/cs345a/slides/12-clustering.pdf)
*   [Алгоритмы кластеризации: от начала до состояния искусства](https://www.toptal.com/machine-learning/clustering-algorithms)
*   [Кластерный анализ: основные понятия и алгоритмы](https://www-users.cs.umn.edu/~kumar/dmbook/ch8.pdf)
*   [Кластеризация K-сред](https://www.datascience.com/blog/k-means-clustering)
*   [Алгоритм максимизации ожиданий](https://www.cs.utah.edu/~piyush/teaching/EM_algorithm.pdf)
*   [Использование кластеризации K-Means с Python](https://code.likeagirl.io/finding-dominant-colour-on-an-image-b4e075f98097)
