---
title: Dataset Splitting
localeTitle: Разбивка массива данных
---
## Разбивка массива данных

Разделение массива данных на сет для тренировки, тестирования и кросс-валидации относится к общепринятым практикам. Это позволяет настраивать различные параметры модели без принятия суждений, независимо.

### мотивация

Разбивка массива данных возникает как необходимость устранения смещения для обучения данных в моделях машинного обучения. Изменение параметров модели для наилучшего соответствия учебным данным обычно приводит к переобучению модели, что пагубно влияет на ее точность. По этой причине мы разделили массив данных на несколько дискретных подмножеств, на которых мы обучаем разные параметры.

#### Тренировочный сет

Тренировочный сет используется для вычисления параметров, которые ваш алгоритм будет использовать при работе с новыми данными. Этот набор данных обычно составляет 60% -80% от всех доступных вами данных (в зависимости от того, используете ли вы набор кросс-валидации).

#### Сет для кросс-валидации

Сет для кросс-валидации предназначен для выбора модели (обычно ~ 20% массива данных). Используйте этот набор данных, чтобы попробовать различные параметры для алгоритма, прошедшего обучение в наборе обучения. Например, вы можете оценить различные параметры модели (полиномиальная степень или лямбда, параметр регуляризации) в наборе кросс-валидации, чтобы увидеть, что может быть наиболее точным.

#### Сет для тестирования

Сет для тестирования - последний массив данных, который оценивает качество работы модели (обычно ~ 20% от ваших данных). Это источник истины. Ваша точность в предсказании набора тестов - это точность вашего алгоритма машинного обучения.

#### Дополнительная информация:

*   [AWS ML Doc](http://docs.aws.amazon.com/machine-learning/latest/dg/splitting-the-data-into-training-and-evaluation-data.html)
*   [Хорошее сообщение stackoverflow](https://stackoverflow.com/questions/13610074/is-there-a-rule-of-thumb-for-how-to-divide-a-dataset-into-training-and-validatio)
*   [Учебный документ](https://www.mff.cuni.cz/veda/konference/wds/proc/pdf10/WDS10_105_i1_Reitermanova.pdf)
