---
title: Gradient Descent
localeTitle: Градиентный спуск
---
## Градиентный спуск

Градиентный спуск - алгоритм оптимизации для нахождения минимума функции. В глубоком изучении этот алгоритм оптимизации очень полезен, когда параметры не могут быть вычислены аналитически.

![Градиентный спуск](https://upload.wikimedia.org/wikipedia/commons/6/68/Gradient_descent.jpg) То, что вы хотите сделать, - это многократно обновлять значение параметра theta до тех пор, пока вы не уменьшите значение функции стоимости J (θ), близкое к 0;

### Уровень обучения

Размер шага называется скоростью обучения. Более высокая скорость обучения ускоряет итерацию, но может превысить глобальный минимум, ценность, которую мы ищем. С другой стороны, мы могли бы предотвратить это превышение путем уменьшения скорости обучения; но будьте осторожны, что чем меньше вы получаете скорость обучения, тем интенсивнее вычислительная интенсивность. Это может либо излишнее вычисление, либо вы не можете достичь глобального минимума.

### Масштабирование функций

Для проблемы глубокого обучения вам потребуется использовать несколько функций для создания предсказательной модели. Если, например, если вы строите прогностическую модель для ценообразования на дому, вам придется иметь дело с такими функциями, как сама цена, количество комнат, площадь лота и т. Д. И эти функции могут сильно отличаться по диапазону, например, например, в то время как партия площадь может составлять от 0 до 2000 квадратных футов, другие функции, такие как количество комнат, будут от 1 до 9.

В этом случае полезно масштабирование функций, также называемое нормализацией, чтобы убедиться, что алгоритм машинного обучения работает правильно.

### Стохастический градиентный спуск

Проблемы с машинным обучением обычно требуют вычислений по размеру выборки в миллионах, и это может быть очень интенсивно вычислительным.

В стохастическом градиентном спусках вы обновляете параметр градиента стоимости каждого примера, а не сумму градиента стоимости всех примеров. Вы можете получить набор хороших параметров быстрее после нескольких проходов по примерам обучения, таким образом, обучение также происходит быстрее.

### Дальнейшее чтение

*   [Руководство по нейронным сетям и глубокому обучению](http://neuralnetworksanddeeplearning.com/)
*   [Градиентный спуск для машинного обучения](https://machinelearningmastery.com/gradient-descent-for-machine-learning/)
*   [Разница между градиентом градиента и стохастическим градиентом](https://towardsdatascience.com/difference-between-batch-gradient-descent-and-stochastic-gradient-descent-1187f1291aa1)