---
title: Dimension Reduction
localeTitle: Уменьшение размеров
---
## Уменьшение размеров

Работа с множеством измерений может быть болезненной для алгоритмов машинного обучения. Высокая размерность увеличит вычислительную сложность, увеличит риск переобучения (поскольку ваш алгоритм имеет больше степеней свободы), а разреженность данных будет расти. Следовательно, уменьшение размерности будет проектировать данные в пространстве с меньшей размерностью, чтобы ограничить эти явления.

## Почему уменьшение размерности полезно?

*   Проекция в два измерения часто используется для облегчения визуализации наборов данных с большими размерами.
    
*   Когда измерениям может быть дана значимая интерпретация, проецирование по этому измерению может быть использовано для объяснения определенного поведения.
    
*   В контролируемом учебном случае уменьшение размерности может быть использовано для уменьшения размера функций, что может привести к повышению производительности для алгоритма обучения.
    

## Методы уменьшения размерности

*   Линейный дискриминантный анализ [LDA](http://scikit-learn.org/stable/modules/lda_qda.html)
*   Анализ основных компонентов [PCA](http://setosa.io/ev/principal-component-analysis/)
*   Kernel PCA
*   Графическое ядро ​​PCA
*   t-распределенное стохастическое соседнее вложение [t-SNE](https://lvdmaaten.github.io/tsne/)
*   [Автокодеры](https://medium.com/towards-data-science/reducing-dimensionality-from-dimensionality-reduction-techniques-f658aec24dfe)
*   Обобщенный дискриминантный анализ (GDA)
*   автоассоциатор

#### Дополнительная информация:

*   [Пошаговое руководство к основному анализу компонентов](https://plot.ly/ipython-notebooks/principal-component-analysis/#introduction)
*   [Методы уменьшения размерности](https://medium.com/towards-data-science/reducing-dimensionality-from-dimensionality-reduction-techniques-f658aec24dfe)
*   [Методы уменьшения размерности: с чего начать](https://blog.treasuredata.com/blog/2016/03/25/dimensionality-reduction-techniques-where-to-begin)