---
title: Feature Engineering
localeTitle: Техническая инженерия
---
## Техническая инженерия

Машиноведение лучше всего работает с хорошо сформированными данными. Технология разработки описывает определенные методы, чтобы убедиться, что мы работаем с наилучшим представлением собранных нами данных.

## Почему полезная особенность?

*   Количество и качество характеристик влияют на интеллектуальную мощность модели. Более качественные функции приводят к лучшей модели.
*   Создавайте лучшие модели, беря данные, которые у вас есть, и дополняйте их дополнительной информацией, относящейся к предмету, полученной в другом месте.
*   Новые возможности могут привести к «прорывам» в способности модели предсказать надежный результат.

## Предостережения для разработки

*   Создание новой функции, основанной на известных функциях, может привести к многоколлинеарности, ситуации, когда две функции линейно связаны между собой. Это означает «двойное погружение» в модель и может привести к более подгонке.
*   Больше - не всегда лучше. Добавление функций с плохими прогностическими возможностями может увеличить вычислительное время без добавления преимуществ для модели.

## Примеры разработки функций:

*   Если у вас есть функция «date», попробуйте подмножество в «день недели», «неделя года» или «месяц года». Аналогичным образом создайте функцию AM / PM из «времени суток».
*   Выполните сокращение данных, например, PCA, затем добавьте векторы из PCA в данные как новые функции.
*   Создавайте новые функции путем численного преобразования текущих функций. Примерами могут быть данные преобразования журнала или кодирование категориальных функций в виде чисел (преобразование с низким / средним / высоким на 1/2/3).
*   Используйте данные переписи для создания новых функций (например, среднего дохода), если ваш набор данных содержит информацию о местоположении (город, штат, округ и т. Д.).

Ниже приведены два метода разработки функций: масштабирование и выбор.

### Масштабирование функций

Предположим, что ваши данные содержат вес и высоту людей. Исходное количество этих двух функций имеет высокую разницу (например, 80 кг и 180 см, или 175 фунтов против 5,9 фута), что может повлиять на результат определенного алгоритма машинного обучения. Это особенно характерно для алгоритмов, использующих [функции расстояния](https://en.wikipedia.org/wiki/Euclidean_distance) .

Чтобы исправить это isse, мы представляем необработанные числа в диапазоне от 0 до 1. Мы можем достичь этого, используя формулу: `(x - xMin) / (xMax - xMin)` .

Используя эту формулу, мы должны обратить особое внимание на выбросы, так как они могут резко повлиять на результат, нажав xMax и нажав xMin. Вот почему выбросы часто устраняются до масштабирования.

### Выбор функции

Все дело в определении подмножества функций, которые отвечают за тенденции, которые мы наблюдаем в наших данных.

Почему мы должны заботиться? [Проклятие размерности](https://en.wikipedia.org/wiki/Curse_of_dimensionality) - большой враг во времена Больших Данных. Мы не можем использовать все наши десятки и сотни функций. Это не только повысило бы размерность наших данных через крышу (2 ^ n, где n - количество признаков), но также часто не имеет никакого смысла в конкретных случаях использования. Представьте, что вы хотите предсказать погоду завтра: более вероятно, что прогноз погоды в последние дни более важен в этом сценарии, чем дети, родившиеся в последние дни. Таким образом, вы можете легко устранить функцию младенцев.

Но сейчас забывайте о младенцах, давайте более подробно остановимся.

#### Фильтрация и упаковка

Здесь мы опишем два общих подхода. Методы фильтрации действуют независимо от выбранного вами алгоритма обучения, а методы обертывания включают вашего учащегося.

Методы фильтрации выбирают подмножество функций перед введением данных в ваш алгоритм ML. Они используют, например, корреляцию с текущей предсказанной переменной, чтобы определить, какое подмножество функций выбрать. Эти методы относительно быстро вычисляются, но не используют преимущества [предвзятости учащегося,](https://en.wikipedia.org/wiki/Inductive_bias) потому что фильтрация происходит независимо от выбранной вами модели ML.

Алгоритмы обертки поиска используют преимущества уклонения от учебы, поскольку они включают выбранную вами модель ML. Эти методы работают, удаляя функцию, которая имеет самое низкое изменение в баллах при удалении и повторяет этот процесс до тех пор, пока оценка не изменится значительно. Это означает, что вы снова и снова запускаете свой алгоритм обучения, что может привести к значительным временам вычислений. Эти методы также имеют опасность переобучения, поскольку вы в основном оптимизируете набор функций на основе выбранной вами модели ML.

#### Актуальность

Другим способом выбора функций является использование [BOC (Байесовский оптимальный классификатор)](https://scholar.google.de/scholar?q=Bayes+Optimal+Classifier&hl=en&as_sdt=0&as_vis=1&oi=scholart&sa=X&ved=0ahUKEwiO16X0tIbXAhXiKsAKHbGrBzoQgQMIJjAA) . Эмпирическое правило:

*   особенность очень важна, если ее удаление ухудшает BOC
*   функция слабо актуальна, если она не имеет особого значения и добавление ее в сочетании с другими функциями улучшает BOC
*   в противном случае функция не имеет значения

Ну, не всегда. Это зависит от объема данных и силы конкурирующих сигналов. Вы можете помочь вашему алгоритму «сосредоточиться» на том, что важно, выделив его заранее.

*   Индикаторная переменная от пороговых значений. Предположим, вы изучаете предпочтения алкоголя американскими потребителями, и ваш набор данных имеет возрастную особенность. Вы можете создать индикаторную переменную для возраста> = 21, чтобы отличать субъектов, которые были старше законного возраста для употребления алкоголя.
*   Индикаторная переменная из нескольких функций: вы прогнозируете цены на недвижимость, и у вас есть функции n _спален и n_ ванных комнат. Если дома с 2 кроватями и 2 ванными комнатами дают премию в качестве аренды, вы можете создать индикаторную переменную, чтобы отметить их.
*   Индикаторная переменная для специальных событий: вы моделируете еженедельные продажи для сайта электронной коммерции. Вы можете создать две индикаторные переменные за недели Черной пятницы и Рождества.
*   Индикаторная переменная для групп классов: вы анализируете преобразования веб-сайтов, а ваш набор данных имеет категориальный _источник_ трафика _. Вы можете создать индикаторную переменную для платного_ трафика, помещая наблюдения с значениями источника трафика «Facebook Ads» или «Google Adwords».

## Особенности взаимодействия

Следующий тип инженерных функций включает выделение взаимодействий между двумя или более функциями.

Вы когда-нибудь слышали эту фразу: «сумма больше частей?» Ну, некоторые функции могут быть объединены, чтобы предоставить больше информации, чем они были бы индивидуальными.

В частности, ищите возможности взять сумму, разницу, продукт или долю нескольких функций.

\* Примечание. Мы не рекомендуем использовать автоматический цикл для создания взаимодействий для всех ваших функций. Это приводит к «взрыву функции».

*   Сумма двух функций: Предположим, вы хотите прогнозировать доход на основе предварительных данных о продажах. У вас есть функции продажи _синих_ ручек и продажи _черных_ ручек. Вы могли бы суммировать эти функции, если вы только заботитесь об общем объеме продаж.
*   Разница между двумя функциями: у вас есть _встроенные_ функции дома и дата _покупки_ дома. Вы можете внести свой вклад, чтобы создать _возраст_ объекта house at\_purchase.
*   Продукт двух функций: вы проводите ценовой тест, и у вас есть цена функции и преобразование переменной индикатора. Вы можете взять свой продукт для создания доходности функции.
*   Котировка двух функций: у вас есть набор маркетинговых кампаний с функциями n _кликов и n_ показов. Вы можете разделить клики по показам для создания кликов _к_ показам, что позволяет сравнивать между кампаниями разного объема.

#### Дополнительная информация:

*   [Исследование бумаги «Разработка функций для классификации текста»](https://pdfs.semanticscholar.org/6e51/8946c59c8c5d005054af319783b3eba128a9.pdf)
*   [Статья «Знакомство с конструкторской конструкцией, как инженерные функции и как стать хорошим в этом»](https://machinelearningmastery.com/discover-feature-engineering-how-to-engineer-features-and-how-to-get-good-at-it/)
*   [Полное руководство по анализу данных](https://www.analyticsvidhya.com/blog/2016/01/guide-data-exploration/)
*   [Преобразование данных](https://onlinecourses.science.psu.edu/stat501/node/318)
*   [Разработка функций в науке о данных](https://docs.microsoft.com/en-us/azure/machine-learning/team-data-science-process/create-features)