---
title: Glossary
localeTitle: глоссарий
---
## глоссарий

Быстрое одно или два предложения, описывающие общие термины. См. Отдельные страницы для более подробно.

*   **Machine Learning** - Пересечение статистики и информатики в чтобы научить компьютеры выполнять задачи без явного программирования.
*   **Глубокое обучение** - общий термин для методов машинного обучения, основанный на представлении данных обучения, в отличие от алгоритмов, основанных на выполнении данной задачи. Он включает в себя такие архитектуры, как глубокие нейронные сети, сети глубоких убеждений и повторяющиеся нейронные сети.
*   **Neuroevolution** - **универсальный** термин для методов машинного обучения, основанный на генерации нейронных сетей через вес, смещение и архитектуру посредством случайных мутаций сети. Наиболее распространенными формами нейроэволюции являются нейроэволюция дополняющих топологий ( [NEAT](https://en.wikipedia.org/wiki/Neuroevolution_of_augmenting_topologies) ) и интерактивно ограниченная [нейроэволюция](http://ikw.uni-osnabrueck.de/~neurokybernetik/media/pdf/2012-1.pdf) ( [ICONE](http://ikw.uni-osnabrueck.de/~neurokybernetik/media/pdf/2012-1.pdf) ).
*   **Статистическое обучение** - использование машинного обучения с целью статистический вывод, в котором вы делаете выводы из данных, а не сосредоточить внимание на точности прогнозирования
*   **Управленческое обучение** - использование исторических данных для прогнозирования будущего. Пример: использование исторических данных о ценах, в которых продавались дома, для прогнозирования цены, в которой будет продаваться ваш дом. Регрессия и классификация подпадают под контролируемое обучение.
*   **Неконтролируемое обучение** - поиск шаблонов в немаркированных данных. Пример. Группировка клиентов путем покупки. Кластеризация происходит под неконтролируемым обучением.
*   **Усиление обучения** - использование имитируемой или реальной среды, в которой алгоритм машинного обучения получает ввод и разреженные вознаграждения для построения модели для прогнозирования действий. Усиление обучения использовалось [для обучения виртуальных роботов, чтобы сбалансировать себя](https://blog.openai.com/competitive-self-play/) и [победить в играх, предназначенных для людей](https://blog.openai.com/openai-baselines-dqn/) .
*   **Регрессия** . Метод машинного обучения, используемый для прогнозирования непрерывных значений. Линейная регрессия - один из самых популярных алгоритмов регрессии.
*   **Классификация** - метод машинного обучения, используемый для прогнозирования дискретных значений. Логистическая регрессия - один из самых популярных алгоритмов классификации.
*   **Обучение правилу ассоциации** - метод машинного обучения на основе правил для обнаружения интересных связей между переменными в больших базах данных.
```
f: x -> y 
 
 Here 'f' is a function that takes 'x' as input and produces 'y' as output. 
 
 If the output value 'y' is a real number / continous value then the function 
 is a regression technique. 
 
 If the output value 'y' is a discrete / categorical value then the function is a classification technique. 
```

*   **Кластеризация** - группировка немаркированных данных. Определение шаблонов с использованием статистики.
    
*   **Уменьшение размерности.** Уменьшение числа случайных величин в данных для получения более точных прогнозов.
    
*   **Случайные леса.** Случайные леса или леса с произвольным решением являются методом обучения ансамблем для классификации, регрессии и других задач, которые работают путем построения множества деревьев решений во время обучения и вывода класса, который является режимом классов или средним предсказанием отдельные деревья. - **Байесовские сети.** Байесовская сеть представляет собой вероятностную графическую модель, которая связывает набор случайных величин со своими условными независимыми функциями через ориентированный ациклический граф (DAG). Простым образом он связывает случайную переменную с их условными независимыми значениями для предсказания события. Она играет решающую роль в связи с ключом к делу. - **Компромисс** смещения смещения - смещение полезно, потому что оно помогает нам определить среднюю разницу в прогнозируемых значениях и фактических значениях, тогда как дисперсия помогает нам определить, как разные предикаты одного набора данных отличаются друг от друга. Если смещение увеличивается, то модель имеет высокую погрешность в прогнозах, что делает модель недооцененной. Высокая дисперсия делает модель переоценкой, поскольку модель постоянно движется только по данному набору данных и плохо выполняет данные, которые она еще не увидела. Поиск баланса между смещением и дисперсией является ключом к созданию хорошей модели.
    

### Дополнительная информация:

*   [Глоссарий терминов - робототехника](http://robotics.stanford.edu/~ronnyk/glossary.html)
*   [Глоссарий терминов - машинное обучение, статистика и наука о данных](https://www.analyticsvidhya.com/glossary-of-common-statistics-and-machine-learning-terms/)