---
title: Machine Learning
localeTitle: Машинное обучение
---
## Машинное обучение

Артур Самуэль, пионер в области искусственного интеллекта, определил Machine Learning в 1959 году как «поле обучения, которое дает компьютерам возможность учиться, не будучи явно запрограммированным».

Более формальное определение машинного обучения предоставляется профессором Томом Митчеллом из КМУ:

> «Говорят, что компьютерная программа учится на опыте E по отношению к некоторому классу задач T и показателю производительности P, если его производительность при заданиях в T, измеряемая P, улучшается с опытом E."

Рассмотрим пример алгоритма машинного обучения, который играет в шахматы. В этом примере `E` относится к опыту игры в шахматы, `T` - игра в шахматы, а `P` означает вероятность того, что программа выиграет следующую игру в шахматы.

Машиноведение в точности похоже на то, как человек учится. Например, если человек хочет научиться играть в покер, он сначала изучит правила. Затем он попытается получить опыт, играя в игру. Этот опыт представляет собой не что иное, как огромный набор данных для машины, с помощью которого он может принимать разумные решения, решая предлагаемую проблему.

В общем, проблемы машинного обучения можно разделить на контролируемое обучение и неконтролируемое обучение. В контролируемом обучении у вас есть вход и помеченный вывод, и вы подозреваете, что существует связь между вводом и помеченным выводом. Когда вы не знаете, что такое помеченный вывод, и не существует отношений, неконтролируемое обучение поможет вам найти структуру в ваших данных, если она есть.

Мы рассмотрели две основные категории машинного обучения, но есть четыре широкие категории машинного обучения:

1.  Контролируемое обучение
2.  Неконтролируемое обучение
3.  Полу-контролируемое обучение
4.  Укрепление обучения

### Контролируемое обучение

Контролируемое обучение - это задача машинного обучения вывода функции из контролируемых данных обучения. Тренировка данные состоят из набора примеров обучения. В контролируемом обучении каждый пример представляет собой пару, состоящую из входного объекта (обычно вектор) и желаемое выходное значение (также называемое контрольным сигналом). Кроме того, контролируемое обучение можно принять за 2 парадигмы, классификацию и регрессию.

#### Основная блок-схема / шаги для контролируемого обучения

1.  Собирайте набор тренировок.
2.  Разделить тренировку на входной объект (функции) и выходной объект (классы или значение)
3.  Решите, что вы будете применять, регрессию или классификатор
4.  Определите, какой алгоритм вы будете применять, SVM, глубокая сеть и т. Д.
5.  Запустите алгоритм обучения и используйте модель для предсказаний

#### Курсы:

1.  [Введение в машинное обучение](https://www.udacity.com/course/intro-to-machine-learning--ud120?autoenroll=true)
2.  [Machine Learning - Учить: Andrew Ng](https://www.coursera.org/learn/machine-learning)
3.  [Науки о данных и машинное обучение с помощью Python - Hands On!](https://www.udemy.com/data-science-and-machine-learning-with-python-hands-on/)
4.  [Машинное обучение](http://ciml.info/)
5.  [Край Аналитики - Преподаватель: MIT](https://www.edx.org/course/the-analytics-edge)

#### Видео ресурсы:

1.  [Канал Siraj Raval's Youtube](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A)
2.  [Канал Sentdex Youtube](https://www.youtube.com/channel/UCfzlCWGWYyIQ0aLC5w48gBQ)

#### Дополнительная информация:

1.  [Машиноведение в Википедии](https://en.wikipedia.org/wiki/Machine_learning)
2.  [Machine Learning Demystified: Youtube](https://www.youtube.com/watch?v=83uAOzhzs-U)
3.  Если вы хотите кратко познакомиться с машинным обучением, и вы предпочитаете видео, попробуйте эту [презентацию для ознакомления с машиной](https://youtu.be/cKxRvEZd3Mw)
4.  Если вы хотите узнать, как продолжить обучение в обучении, взгляните на это [видео](https://youtu.be/nKW8Ndu7Mjw)

## лаборатория

[Создание смарт-приложений с помощью студии Azure Machine Learning Studio](https://github.com/Microsoft/computerscience/blob/master/Labs/AI%20and%20Machine%20Learning/Azure%20Machine%20Learning/Azure%20Machine%20Learning%20(Node).md)