---
title: Latent Dirichlet Allocation
localeTitle: Скрытое распределение Дирихле
---
При обработке на естественном языке скрытое распределение Дирихле (LDA) представляет собой генеративную статистическую модель, которая позволяет объяснять группы наблюдений ненаблюдаемыми группами, которые объясняют, почему некоторые части данных схожи. Например, если наблюдения представляют собой слова, собранные в документы, в нем говорится, что каждый документ представляет собой смесь небольшого количества тем и что создание каждого слова относится к одной из тем документа. LDA - пример тематической модели.

Предположим, что у вас есть следующий набор предложений:

Я завтракал с бананом и шпинатом Мне нравится есть брокколи и бананы. Шиншиллы и котята милы. Вчера моя сестра приняла котенка. Посмотрите на этого милого хомяка, жующего кусок брокколи.

Скрытое распределение Дирихле - это способ автоматического обнаружения тем, содержащихся в этих предложениях. Например, учитывая эти предложения и попросив 2 темы, LDA может произвести что-то вроде

Предложения 1 и 2: 100% Тема A Предложения 3 и 4: 100% Тема B Предложение 5: 60% Тема А, 40% Тема B Тема А: 30% брокколи, 15% бананов, 10% завтрак, 10% жевание, ... (в этот момент вы могли бы толковать тему А о еде) Тема B: 20% шиншилл, 20% котят, 20% милый, 15% хомяк, ... (в этот момент вы могли бы толковать тему B о симпатичных животных)

Вопрос, конечно, в следующем: как LDA выполняет это открытие?

Модель LDA

Более подробно, LDA представляет документы в виде смесей тем, которые выплевывают слова с определенными вероятностями. Предполагается, что документы создаются следующим образом: при написании каждого документа вы

Определите количество слов N, которое будет иметь документ (скажем, согласно распределению Пуассона). Выберите тему для документа (в соответствии с распределением Дирихле по фиксированному набору тем К). Например, если предположить, что у нас есть две темы с пищей и милыми животными выше, вы можете выбрать документ, состоящий из 1/3 пищи и 2/3 милых животных. Создайте каждое слово в документе: .... Сначала выбираем тему (в соответствии с мультиномиальным распределением, которое вы выбрали выше, например, вы можете выбрать тему пищи с вероятностью 1/3 и тему симпатичных животных с вероятностью 2/3). ... Затем используйте тему для генерации самого слова (в соответствии с многотомным распределением темы). Например, тема питания может вывести слово «брокколи» с вероятностью 30%, «бананы» с вероятностью 15% и т. Д.

Предполагая эту генеративную модель для набора документов, LDA затем пытается отступить от документов, чтобы найти набор тем, которые, вероятно, сгенерировали коллекцию.

пример

Давайте сделаем пример. Согласно вышеописанному процессу, когда вы создаете какой-то конкретный документ D, вы можете

Решите, что D будет 1/2 о еде и 1/2 о милых животных. Выберите 5, чтобы указать количество слов в D. Выберите первое слово из темы пищи, которое затем дает вам слово «брокколи». Выберите второе слово из темы милых животных, которая дает вам «панду». Выберете третье слово из темы симпатичных животных, придав вам «восхитительный». Выберите четвертое слово из темы пищи, давая вам «вишни». Выберите пятое слово из темы пищи, давая вам «поесть».

Таким образом, документ, созданный под моделью LDA, будет «брокколи panda восхитительные вишни» (обратите внимание, что LDA - модель с мешком).

Обучение

Итак, теперь предположим, что у вас есть набор документов. Вы выбрали определенное фиксированное количество тем K для открытия и хотите использовать LDA для изучения представления темы каждого документа и слов, связанных с каждой темой. Как ты делаешь это? Один из способов (известный как свернутый выборки Гиббса \*) заключается в следующем:

Пройдите каждый документ и произвольно назначьте каждое слово в документе одной из тем K. Обратите внимание, что это случайное присваивание уже дает вам оба представления по темам всех документов и распределений слов по всем темам (хотя и не очень хорошие). Чтобы улучшить их, для каждого документа d ... ... через каждое слово w в d ... ...... .И для каждой темы t вычислите две вещи: 1) p (topic t | document d) = доля слов в документе d, которые в настоящее время назначены теме t, и 2) p (word w | topic t ) = доля присвоений теме t по всем документам, которые поступают из этого слова w. Reassign wa новая тема, где вы выбираете тему t с вероятностью p (тема t | document d) \* p (word w | topic t) (согласно нашей генеративной модели, это по существу вероятность того, что тема t сгенерировала слово w, так что имеет смысл, что с этой вероятностью мы пересматриваем тему текущего слова). (Кроме того, я замалчиваю пару вещей здесь, например, использование priors / pseudocounts в этих вероятностях.) ...... .. Иными словами, на этом этапе мы предполагаем, что все назначения тем, за исключением текущего слова, правильные, а затем обновление назначения текущего слова с использованием нашей модели создания документов. Повторяя предыдущий шаг много раз, вы, в конечном счете, достигнете примерно устойчивого состояния, когда ваши задания довольно хороши. Поэтому используйте эти присваивания для оценки тематических смесей каждого документа (путем подсчета доли слов, назначенных каждой теме в этом документе), и слов, связанных с каждой темой (путем подсчета доли слов, присвоенных каждой теме в целом).

Объяснение Лэймена

В случае, если обсуждение выше было немного остеклением, вот еще один способ взглянуть на LDA в другом домене.

Предположим, вы только что переехали в новый город. Вы хипстер и фанат аниме, поэтому вы хотите знать, где другие хипстеры и аниме-гики, как правило, болтаются. Конечно, как хипстер, вы знаете, что не можете просто спросить, так что вы делаете?

Вот сценарий: вы просматриваете множество разных заведений (документов) по всему городу, отмечая людей (слов), висящих в каждом из них (например, Алиса висит в торговом центре и в парке, Боб висит на кинотеатр и парк, и так далее). Реально, вы не знаете типичных групп интересов (тем) каждого заведения, и вы не знаете различных интересов каждого человека.

Таким образом, вы выбираете количество категорий K для обучения (т. Е. Вы хотите изучить K самых важных видов категорий, в которые люди попадают), и начните с того, чтобы угадать, почему вы видите людей, где вы делаете. Например, вы изначально предполагаете, что Алиса находится в торговом центре, потому что люди с интересами в X любят там выходить; когда вы видите ее в парке, вы предполагаете, что это связано с тем, что ее друзья с интересами в Y любят тусоваться там; когда вы видите Боба в кинотеатре, вы случайно предполагаете, что это потому, что люди Z в этом городе очень любят смотреть фильмы; и так далее.

Конечно, ваши случайные догадки, скорее всего, будут неправильными (это случайные догадки, в конце концов!), Поэтому вы хотите улучшить их. Один из способов сделать это:

Выберите место и человека (например, Алиса в торговом центре). Почему Алиса, вероятно, будет в торговом центре? Наверное, потому, что другие люди в торговом центре с такими же интересами послали ей сообщение, в котором говорилось, что она придет. Другими словами, чем больше людей с интересами в X есть в торговом центре, а более сильная Алиса связана с интересом X (во всех других местах, куда она идет), тем более вероятно, что Алиса находится в торговом центре из-за интереса ИКС. Так что сделайте новое предположение о том, почему Алиса находится в торговом центре, выбирая интерес с некоторой вероятностью в зависимости от того, насколько вы вероятно считаете это.

Пройдите через каждое место и снова и снова. Ваши догадки продолжают становиться все лучше и лучше (в конце концов, если вы заметите, что в книжном магазине выезжают много вундеркиндов, и вы подозреваете, что Алиса очень вынашивает себя, тогда это хорошая ставка, что Алиса в книжном магазине, потому что ее друзья-выродки сказали ее, чтобы пойти туда, и теперь, когда у вас есть лучшее представление о том, почему Алиса, вероятно, находится в книжном магазине, вы можете использовать это знание в свою очередь, чтобы улучшить свои догадки о том, почему все остальные там, где они есть), и поэтому в конечном итоге вы можете остановить обновление. Затем сделайте снимок (или несколько снимков) ваших догадок и используйте его, чтобы получить всю необходимую информацию:

Для каждой категории вы можете подсчитать людей, назначенных этой категории, чтобы выяснить, что у людей есть этот особый интерес. Рассматривая самих людей, вы также можете интерпретировать эту категорию (например, если категория X содержит много высоких людей, носящих майки и несущих баскетбол, вы можете интерпретировать X как группу «баскетболистов»). Для каждого места P и категории интересов C вы можете вычислить пропорции людей в P из-за C (под текущим набором назначений), и это дает вам представление P. Например, вы можете узнать, что люди, которые висеть в Barnes & Noble состоят из 10% хипстеров, 50-процентных поклонников аниме, 10% -ов и 30% студентов колледжа.

Пример реального мира

Наконец, давайте рассмотрим пример реального мира. Я применил LDA к набору писем Сары Пэлин некоторое время назад (см. Http://blog.echen.me/2011/06/27/... для сообщения в блоге, или http://sarah-palin.heroku.com / для приложения, которое позволяет просматривать электронные письма по изученным LDA темам), так что вот некоторые из тем, которые изучил алгоритм:

Trig / Family / Inspiration: family, web, mail, god, son, from, поздравления, дети, жизнь, ребенок, вниз, триггер, ребенок, рождение, любовь, вы, синдром, очень, особенный, благословение, лет, спасибо, лучше всего ... Дикая природа / BP Коррозия: игра, рыба, лося, дикая природа, охота, медведи, полярные, медведи, суточные, управление, площадь, доска, охота, волки, контроль, отдел, год, использование, волк, среда обитания, охотники, карибу, программа , денби, рыбалка, ... Энергия / Топливо / Нефть / Добыча: энергия, топливо, затраты, нефть, аляски, цены, стоимость, ном, сейчас, высокая, бытие, дом, общественность, власть, шахта, кризис, цена, ресурс, потребность, сообщество, скидки, использование, добыча, деревни, ... Газ: газ, нефть, трубопровод, агия, проект, природный, север, производители, компании, налоги, компания, энергия, развитие, склон, производство, ресурсы, линия, газопровод, трансканада, сказал, миллиард, план, промышленность, … Образование / Отходы: школа, отходы, образование, студенты, школы, миллион, чтение, электронная почта, рынок, политика, студент, год, высокая, новости, штаты, программа, во-первых, отчет, бизнес, управление, бюллетень, 2008, квартал, ... Президентская кампания / Выборы: почта, интернет, от, спасибо, ящик, mccain, sarah, очень, хороший, отличный, джон, надежда, президент, искренне, wasilla, работа, поддержка, создание, добавление, семья, республиканец, поддержка , делая, po, ...

#### Предлагаемое чтение:

*   https://en.wikipedia.org/wiki/Латентное распределение _Дирихле_
*   http://blog.echen.me/2011/08/22/introduction-to-latent-dirichlet-allocation/