---
title: Logistic Regression
localeTitle: Логистическая регрессия
---
## Логистическая регрессия

![Логистическая функция](https://qph.fs.quoracdn.net/main-qimg-7c9b7670c90b286160a88cb599d1b733) Логистическая регрессия очень похожа на линейную регрессию в том, что она пытается предсказать переменную ответа Y, учитывая набор входных переменных X. Это форма контролируемого обучения, которая пытается предсказать ответы немеченых, невидимых данных путем первого обучения с помеченными данными, набора наблюдений как независимых (X), так и зависимых (Y) переменных. Но в то время как [линейная регрессия](https://guide.freecodecamp.org/machine-learning/linear-regression) предполагает, что переменная ответа (Y) является количественной или непрерывной, логистическая регрессия используется конкретно, когда переменная ответа является качественной или дискретной. ![Линейный против логистики](http://www.saedsayad.com/images/LogReg_1.png)

#### Как это устроено

Логистическая регрессия моделирует вероятность того, что Y, переменная ответа, относится к определенной категории. Во многих случаях переменная ответа будет бинарной, поэтому логистическая регрессия будет хотеть моделировать функцию y = f (x), которая выводит нормированное значение, которое варьируется от, скажем, от 0 до 1 для всех значений X, что соответствует два возможных значения Y. Он делает это с помощью логистической функции: Логистическая регрессия - это соответствующий регрессионный анализ для проведения, когда зависимая переменная является дихотомической (двоичной). Как и все регрессионные анализы, логистическая регрессия является прогнозирующим анализом. Логистическая регрессия используется для описания данных и объяснения взаимосвязи между одной зависимой двоичной переменной и одной или несколькими номинальными, порядковыми, интервальными или независимыми от отношения уровнями значениями.

![Функция стоимости](https://cdn-images-1.medium.com/max/800/1*wHtYmENzug_W6fIE9xY8aw.jpeg) Логистическая регрессия используется для решения задач классификации, где выход имеет вид y∈ {0,1}. Здесь 0 - отрицательный класс, а 1 - положительный класс. Предположим, что мы имеем гипотезу hθ (x), где x - наш набор данных (матрица) длины m. θ является параметрической матрицей. Имеем: 0 <hθ (x) <1

В логистической регрессии hθ (x) является сигмоидной функцией, поэтому hθ (x) = g (θ'x). g (θ'x) = 1/1 + e ^ (- θ'x)

Примечание: θ 'является транспонированным.

#### Функция стоимости

Функция затрат, используемая для логистической регрессии:

J (θ) = (1 / m) ΣCost (hθ (x (i)), y (i)), где суммирование производится от i = 1 до m.

Стоимость (hθ (x), y) = - log (hθ (x)), если y = 1 Стоимость (hθ (x), y) = - log (1-hθ (x)), если y = 0

#### Прогнозы с использованием логистической регрессии:

Логистическая регрессия моделирует вероятность класса по умолчанию (т.е. первого класса). Вы можете классифицировать результаты, полученные:

y = e ^ (b0 + b1 _X) / (1 + e ^ (b0 + b1_ X))

на два класса. Как и для сигмоидной функции 0.5, устанавливается в качестве границы решения все x, для которых y≥0.5 классифицируются как класс A и для которых y <0,5 классифицируются как класс B.

#### Логистическая регрессия нескольких классов:

Хотя вы увидите, что логистическая регрессия обычно используется в случае двоичной классификации, но вы также можете использовать ее в случае классификации в нескольких классах:

##### один против одного метода:

Здесь классификатор для каждого класса создается отдельно, а классификатор с наивысшим результатом считается выходным.

##### один против всего метода:

Здесь производятся множественные (N \* N (N-1) / 2, где N = нет классов) бинарные классификаторы, а затем путем сравнения их результатов получается результат.

#### Приложения логистической регрессии:

1) Классифицировать почту как спам или спам. 2) Определить наличие или отсутствие определенных заболеваний, таких как рак, на основании симптомов и других медицинских данных. 3) Классифицировать изображения на основе данных пикселей.

#### Логистические регрессионные предположения

Двоичная логистическая регрессия требует, чтобы зависимая переменная была двоичной. Для двоичной регрессии фактор 1 зависимой переменной должен представлять желаемый результат. Должны быть включены только значимые переменные. Независимые переменные должны быть независимыми друг от друга. То есть модель должна иметь мало или вообще не мультиколлинеарность. Независимые переменные линейно связаны с логарифмическими коэффициентами. Логистическая регрессия требует довольно больших размеров выборки.

#### Дополнительная информация:

Для дальнейшего чтения для постепенного создания логистической регрессии:

*   Нажмите [здесь](https://medium.com/towards-data-science/building-a-logistic-regression-in-python-step-by-step-becd4d56c9c8) для статьи о построении логистической регрессии в Python.
*   Нажмите [здесь](http://nbviewer.jupyter.org/gist/justmarkham/6d5c061ca5aee67c4316471f8c2ae976) для другой статьи о построении логической регрессии.
*   Нажмите [здесь](http://nbviewer.jupyter.org/gist/justmarkham/6d5c061ca5aee67c4316471f8c2ae976) для другой статьи по математике и интуиции за логической регрессией.