---
title: Monte Carlo
localeTitle: Монте-Карло
---
## Монте-Карло

Монте-Карло - это класс методов моделирования, который позволяет вам исследовать пространство решения проблемы, которое имеет входы, которые могут принимать несколько значений. Путем запуска моделирования с рандомизированными входами и параметрами модели вы можете наблюдать за результатами, которые возникают из-за входов, которые могут быть другими, которые не были протестированы. Метод полезен для решения проблем, которые могут быть слишком трудными для решения аналитически. Это не точный метод, а эвристический, который обычно использует случайность и статистику, чтобы получить результат. Алгоритм завершается правильным ответом с ответом.

Это процесс вычисления, который использует случайные числа для получения результата (результатов). Вместо фиксированных входов распределение вероятностей присваивается некоторым или всем входам. Это сгенерирует распределение вероятности для выхода после запуска моделирования.

Например, для оценки значения π можно использовать алгоритм Монте-Карло. Величина площади в пределах четверти круга радиуса 1 зависит от значения π. Вероятность того, что случайно выбранная точка будет лежать в этом четверть круга, зависит от площади круга. Если точки помещаются случайным образом в квадрат со сторонами длины 1, процент точек, попадающих в четверть круга с радиусом 1, будет зависеть от значения π. Алгоритм Монте-Карло случайным образом помещает точки в квадрат и использует процент точек, попадающих внутри круга, для оценки значения π. Это эффективный способ для приближения.

В современных системах связи качество обмена информацией определяется наличием шума в канале. Основной источник шума - аддитивный белый гауссовский шум (AWGN), являющийся случайным по своей природе, может быть охарактеризован с использованием алгоритма Монте-Карло при имитации системы связи.

### Дополнительная информация:

*   [Википедия](https://en.wikipedia.org/wiki/Monte_Carlo_method)
*   [Wolfram MathWorld](http://mathworld.wolfram.com/MonteCarloMethod.html)
*   [Статья Minitab - Монте-Карло не так сложна, как вы думаете](http://blog.minitab.com/blog/understanding-statistics/monte-carlo-is-not-as-difficult-as-you-think)
*   [Алгоритм Монте-Карло (4:41)](https://www.youtube.com/watch?v=Q2-FH36LuT0)