---
title: Natural Language Processing
localeTitle: Обработка естественного языка
---
## Обработка естественного языка (НЛП)

Как говорит Википедия, «обработка естественного языка (NLP) является подполем компьютерной науки, информатики и искусственного интеллекта, связанным с взаимодействием между компьютерами и человеческими (естественными) языками, в частности, как программировать компьютеры для обработки и анализа больших объемов данных естественного языка ». Проще говоря, это процесс, в котором естественный язык, порожденный людьми, воспринимается компьютерами.

### Проблемы в НЛП

#### 1\. Легко или в основном решено
```
          *Spam detection 
          *Part of Speech Tagging 
          *Named Entity Recognition 
```

#### 2\. Внедрение или достижение хорошего прогресса
```
          *Sentiment analysis 
          *Coreference resolution 
          *Word sense disambiguation 
          *Parsing 
          *Machine Translation 
          *Information Translation 
```

#### 3.Гард или еще нужно много работы
```
          *Text Summarization 
          *Machine dialog system 
```

### Общие методы
```
         *Structure extraction 
         *Identify and mark sentence, phrase, and paragraph boundaries 
         *Language identification 
         *Tokenization 
         *Acronym normalization and tagging 
         *Lemmatization / Stemming 
         *Entity extraction 
         *Phrase extraction 
```

### Популярные библиотеки
```
            *NLTK, the most widely-mentioned NLP library for Python. 
        *SpaCy, an industrial-strength NLP library built for performance. 
        *Gensim, a library for document similarity analysis. 
        *TextBlob, a user-friendly and intuitive NLTK interface. 
        *CoreNLP from stanford group 
        *PolyGlot, a natural language pipeline that supports massive multilingual applications. 
```

#### Дополнительная информация:

Для дальнейшего чтения:

*   Нажмите [здесь](https://medium.com/@gon.esbuyo/get-started-with-nlp-part-i-d67ca26cc828) для статьи о вступлении в НЛП.
*   Нажмите [здесь](https://en.wikipedia.org/wiki/Natural_language_processing) для ссылки в Википедии.