---
title: Generative Adversarial Networks
localeTitle: Генерирующие Adversarial Networks
---
## Генерирующие Adversarial Networks

## обзор

Генерирующие состязательные сети (GAN) - это класс алгоритмов [искусственного интеллекта](https://en.wikipedia.org/wiki/Artificial_intelligence) , используемых в [неконтролируемом компьютерном обучении](https://en.wikipedia.org/wiki/Unsupervised_machine_learning) , реализуемый системой двух [нейронных сетей,](https://en.wikipedia.org/wiki/Neural_network) конкурирующих друг с другом в игровой системе с нулевой суммой. Они были представлены Ян Гудфеллоу и др. в 2014 году. Этот метод может генерировать фотографии, которые выглядят, по крайней мере, поверхностно аутентичными для наблюдателей-людей, обладающих множеством реалистичных характеристик (хотя в тестах люди могут сказать реальные из-за сгенерированных во многих случаях).

## метод

Одна сеть генерирует кандидатов (генеративных), а другая [оценивает их](https://en.wikipedia.org/wiki/Turing_test) (дискриминационную). Как правило, генерирующая сеть учится отображать из [скрытого пространства](https://en.wikipedia.org/wiki/Latent_variable) в конкретное распределение данных, представляющее интерес, в то время как дискриминационная сеть различает экземпляры от истинного распределения данных и кандидатов, созданных генератором. Цель обучения генеративной сети - увеличить частоту ошибок дискриминационной сети (т. Е. «Обмануть» сеть дискриминаторов, создавая новые синтезированные экземпляры, которые, как представляется, исходят из истинного распределения данных).

На практике известный набор данных служит исходными данными обучения для дискриминатора. Обучение дискриминатора предполагает представление его с образцами из набора данных, пока он не достигнет определенного уровня точности. Обычно генератор засевается рандомизированным входом, который выбирается из предопределенного скрытого пространства (например, [многомерного нормального распределения](https://en.wikipedia.org/wiki/Multivariate_normal_distribution) ). После этого образцы, синтезированные генератором, оцениваются дискриминатором. [Backpropagation](https://en.wikipedia.org/wiki/Backpropagation) применяется в обеих сетях, так что генератор создает более качественные изображения, в то время как дискриминатор становится более опытным при маркировке синтетических изображений. Генератор обычно является деконволюционной нейронной сетью, а дискриминатор представляет собой [сверточную нейронную сеть](https://en.wikipedia.org/wiki/Convolutional_neural_network) .

Идея вывести модели в конкурентной среде (модель против дискриминатора) была предложена Ли, Гаучи и Гросом в 2013 году. Их метод используется для поведенческого вывода. Это называется Тьюрингом Изучением, так как эта настройка аналогична настройке [теста Тьюринга](https://en.wikipedia.org/wiki/Turing_test) . Обучение Тьюринга - это обобщение ГАН. Могут рассматриваться модели, отличные от нейронных сетей. Более того, дискриминаторам разрешено влиять на процессы, из которых получены наборы данных, делая их активными запросчиками, как в тесте Тьюринга. Идея о состязательном обучении также можно найти в более ранних работах, таких как Шмидхубер в 1992 году.

## заявка

GAN были использованы для производства образцов [фотореалистичных](https://en.wikipedia.org/wiki/Photorealistic) изображений для визуализации нового интерьера / промышленного дизайна, обуви, сумок и предметов одежды или предметов для сцен компьютерных игр. Сообщалось, что эти сети используются Facebook. Недавно GAN смоделировали модели движения в видео. Они также использовались для восстановления 3D-моделей объектов с изображений и улучшения астрономических изображений. В 2017 году для ускорения изображения с использованием автоматизированного синтеза текстур в сочетании с перцептивной потерей был использован полностью сверточный комбинированный GAN-фильтр. Система фокусировалась на реалистичных текстурах, а не на пиксельной точности. Результатом было высокое качество изображения при высоком увеличении.