---
title: Neural Networks
localeTitle: Нейронные сети
---
## Нейронные сети

![Первичная нейронная сеть](http://ufldl.stanford.edu/tutorial/images/SingleNeuron.png)

Искусственная нейронная сеть - это вычислительная система. Они похожи на биологические нейронные сети, которые составляют мозг животных. Для обучения нейронной сети нам нужен вектор ввода и соответствующий выходной вектор. Обучение работает путем сведения к минимуму ошибки. Эта ошибка может быть квадратичной разницей между прогнозируемым выходом и исходным выходом.

Основным принципом, лежащим в основе замечательного успеха нейронных сетей, является «Универсальная теорема приближения». Математически доказано, что нейронные сети являются универсальными машинами аппроксимации, которые способны аппроксимировать любую математическую функцию между данными входами и выходами.

Первоначально нейронные сети стали популярными в 1980-х годах, но ограничения в вычислительной мощности запрещали их широкое признание до последнего десятилетия. Инновации в размерах и мощности процессора позволяют реализовать нейронную сеть в масштабе, хотя другие парадигмы машинного обучения все еще превосходят нейронные сети с точки зрения эффективности.

Основным элементом нейронной сети является нейрон. Он представляет собой вектор, скажем, `x` , а его вывод является вещественной переменной, например `y` . Таким образом, мы можем заключить, что нейрон действует как отображение между вектором `x` и вещественным числом `y` .

Нейронные сети выполняют регрессию итеративно на нескольких уровнях, что приводит к более тонкой модели прогнозирования. Один узел в нейронной сети вычисляет ту же функцию, что и [логистическая регрессия](../logistic-regression/index.md) . Все эти слои, помимо ввода и вывода, скрыты, то есть конкретные черты, представленные этими уровнями, не выбраны или не изменены программистом.

![Четырехслойная нейронная сеть](http://cs231n.github.io/assets/nn1/neural_net2.jpeg)

В любом данном слое каждый узел принимает все значения, хранящиеся на предыдущем уровне, в качестве входных данных и делает прогнозы на них на основе анализа логистической регрессии. Сила нейронных сетей заключается в их способности «обнаруживать» модели и черты, невидимые программистами. Как упоминалось ранее, средние слои «скрыты», что означает, что веса, передаваемые переходам, определяются исключительно обучением алгоритма.

Нейронные сети используются по целому ряду задач. К ним относятся компьютерное зрение, распознавание речи, перевод, фильтрация социальной сети, воспроизведение видеоигр и медицинский диагноз между прочим.

### Визуализация

Есть потрясающий инструмент, который поможет вам понять идею нейронных сетей без какой-либо жесткой математики: [TensorFlow Playground](http://playground.tensorflow.org) , веб-приложение, которое позволяет вам играть с реальной нейронной сетью, работающей в вашем браузере, и щелкать кнопками и настраивать параметры, чтобы увидеть, как это работает.

### Проблемы, решаемые с помощью Neural Networks

*   классификация
*   Кластеризация
*   регрессия
*   Обнаружение аномалий
*   Правила ассоциации
*   Укрепление обучения
*   Структурированное прогнозирование
*   Разработка функций
*   Изучение функций
*   Обучение ранжированию
*   Грамматическая индукция
*   Прогноз погоды
*   Создание изображений

### Общие системы нейронных сетей

Самые распространенные нейронные сети, используемые сегодня, относятся к категории [глубокого обучения](https://github.com/freeCodeCamp/guides/blob/master/src/pages/machine-learning/deep-learning/index.md) . Глубокое обучение - это процесс объединения нескольких слоев нейронов, чтобы сеть могла создавать все более абстрактные отображения между входными и выходными векторами. Глубокие нейронные сети чаще всего используют [обратную пропозицию](https://github.com/freeCodeCamp/guides/blob/master/src/pages/machine-learning/backpropagation/index.md) , чтобы сходиться к наиболее точному отображению.

Второй наиболее распространенной формой нейронных сетей является nueroevolution. В этой системе несколько нейронных сетей генерируются случайным образом в качестве исходных догадок. Затем для сближения более точного отображения используются несколько поколений комбинирования точных большинства сетей и случайных перестановок.

### Типы нейронных сетей

*   Рекуррентная нейронная сеть (RNN)
*   Долгосрочная временная память (LSTM), тип RNN
*   Сверточная нейронная сеть (CNN)

### Дополнительная информация:

*   [Нейронные сети - Википедия](https://en.wikipedia.org/wiki/Artificial_neural_network#Components_of_an_artificial_neural_network)
*   [Характер кода Дэниела Шиффмана](http://natureofcode.com/book/chapter-10-neural-networks/)
*   [Стэнфордский университет, многослойные нейронные сети](http://ufldl.stanford.edu/tutorial/supervised/MultiLayerNeuralNetworks/)
*   [Канал 3Blue1Brown, Youtube с содержанием нейронной сети](https://youtu.be/aircAruvnKk)
*   [Siraj Raval, Youtube CHANNEL с содержанием нейронной сети](https://youtu.be/h3l4qz76JhQ)
*   [Нейроэволюция - Википедия](https://en.wikipedia.org/wiki/Neuroevolution)